/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.hadoop.azure.hive;

import com.google.common.base.Joiner;
import com.microsoft.hadoop.azure.hive.EntityPropertyInspector;
import com.microsoft.windowsazure.storage.table.DynamicTableEntity;
import java.sql.Timestamp;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;

class PrimitiveField
implements StructField {
    private final EntityPropertyInspector inspector;
    private final String name;
    private final boolean requireFieldExists;

    public PrimitiveField(String name, EntityPropertyInspector inspector, boolean requireFieldExists) {
        this.name = name;
        this.inspector = inspector;
        this.requireFieldExists = requireFieldExists;
    }

    public String getFieldComment() {
        return null;
    }

    public String getFieldName() {
        return this.name;
    }

    public ObjectInspector getFieldObjectInspector() {
        return this.inspector;
    }

    public Object getData(DynamicTableEntity entity) {
        Object value;
        if (this.name.equalsIgnoreCase("RowKey")) {
            value = entity.getRowKey();
        } else if (this.name.equalsIgnoreCase("PartitionKey")) {
            value = entity.getPartitionKey();
        } else if (this.name.equalsIgnoreCase("Timestamp")) {
            value = new Timestamp(entity.getTimestamp().getTime());
        } else {
            value = entity.getProperties().get(this.name);
            if (value == null) {
                for (String key : entity.getProperties().keySet()) {
                    if (!key.equalsIgnoreCase(this.name)) continue;
                    value = entity.getProperties().get(key);
                    break;
                }
                if (value == null) {
                    if (this.requireFieldExists) {
                        throw new IllegalArgumentException("No property found with name " + this.name + ". Properties found: " + Joiner.on((char)',').join(entity.getProperties().keySet()));
                    }
                    return null;
                }
            }
        }
        return this.inspector.getPrimitiveJavaObject(value);
    }
}

