/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.hadoop.azure.hive;

import com.microsoft.windowsazure.storage.table.EntityProperty;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public abstract class EntityPropertyInspector
extends AbstractPrimitiveJavaObjectInspector {
    private static final Map<String, EntityPropertyInspector> typeToInspector = Collections.unmodifiableMap(new HashMap<String, EntityPropertyInspector>(){
        {
            this.put("string", new StringEntityPropertyInspector());
            this.put("int", new IntEntityPropertyInspector());
            this.put("bigint", new LongEntityPropertyInspector());
            this.put("double", new DoubleEntityPropertyInspector());
            this.put("boolean", new BooleanEntityPropertyInspector());
            this.put("timestamp", new TimestampEntityPropertyInspector());
        }
    });

    public static EntityPropertyInspector getInspectorForType(String typeName) throws SerDeException {
        EntityPropertyInspector ret = typeToInspector.get(typeName);
        if (ret != null) {
            return ret;
        }
        throw new SerDeException("Type " + typeName + " not allowed.");
    }

    protected EntityPropertyInspector(PrimitiveTypeInfo typeInfo) {
        super(typeInfo);
    }

    public Object getPrimitiveJavaObject(Object property) {
        if (EntityProperty.class.isInstance(property)) {
            return this.getPrimitiveJavaObject((EntityProperty)property);
        }
        return super.getPrimitiveJavaObject(property);
    }

    protected abstract Object getPrimitiveJavaObject(EntityProperty var1);

    public static class TimestampEntityPropertyInspector
    extends EntityPropertyInspector
    implements TimestampObjectInspector {
        public TimestampEntityPropertyInspector() {
            super(TypeInfoFactory.timestampTypeInfo);
        }

        @Override
        public Timestamp getPrimitiveJavaObject(EntityProperty property) {
            return new Timestamp(property.getValueAsDate().getTime());
        }

        @Override
        public Timestamp getPrimitiveJavaObject(Object property) {
            if (EntityProperty.class.isInstance(property)) {
                return this.getPrimitiveJavaObject((EntityProperty)property);
            }
            return (Timestamp)super.getPrimitiveJavaObject(property);
        }

        public TimestampWritable getPrimitiveWritableObject(Object value) {
            return new TimestampWritable((Timestamp)value);
        }
    }

    public static class DoubleEntityPropertyInspector
    extends EntityPropertyInspector
    implements DoubleObjectInspector {
        public DoubleEntityPropertyInspector() {
            super(TypeInfoFactory.doubleTypeInfo);
        }

        @Override
        public Object getPrimitiveJavaObject(EntityProperty property) {
            return property.getValueAsDouble();
        }

        public Object getPrimitiveWritableObject(Object property) {
            return new DoubleWritable(((EntityProperty)property).getValueAsDouble());
        }

        public double get(Object value) {
            return (Double)value;
        }
    }

    public static class LongEntityPropertyInspector
    extends EntityPropertyInspector
    implements LongObjectInspector {
        public LongEntityPropertyInspector() {
            super(TypeInfoFactory.longTypeInfo);
        }

        @Override
        public Object getPrimitiveJavaObject(EntityProperty property) {
            return property.getValueAsLong();
        }

        public Object getPrimitiveWritableObject(Object property) {
            return new LongWritable(((EntityProperty)property).getValueAsLong());
        }

        public long get(Object value) {
            return (Long)value;
        }
    }

    public static class BooleanEntityPropertyInspector
    extends EntityPropertyInspector
    implements BooleanObjectInspector {
        public BooleanEntityPropertyInspector() {
            super(TypeInfoFactory.booleanTypeInfo);
        }

        @Override
        public Object getPrimitiveJavaObject(EntityProperty property) {
            return property.getValueAsBoolean();
        }

        public Object getPrimitiveWritableObject(Object property) {
            return new BooleanWritable(((EntityProperty)property).getValueAsBoolean());
        }

        public boolean get(Object value) {
            return (Boolean)value;
        }
    }

    public static class StringEntityPropertyInspector
    extends EntityPropertyInspector
    implements StringObjectInspector {
        public StringEntityPropertyInspector() {
            super(TypeInfoFactory.stringTypeInfo);
        }

        @Override
        public String getPrimitiveJavaObject(EntityProperty property) {
            return property.getValueAsString();
        }

        @Override
        public String getPrimitiveJavaObject(Object property) {
            if (EntityProperty.class.isInstance(property)) {
                return this.getPrimitiveJavaObject((EntityProperty)property);
            }
            return (String)super.getPrimitiveJavaObject(property);
        }

        public Text getPrimitiveWritableObject(Object value) {
            return new Text((String)value);
        }
    }

    public static class IntEntityPropertyInspector
    extends EntityPropertyInspector
    implements IntObjectInspector {
        public IntEntityPropertyInspector() {
            super(TypeInfoFactory.intTypeInfo);
        }

        @Override
        public Object getPrimitiveJavaObject(EntityProperty property) {
            return property.getValueAsInteger();
        }

        public Object getPrimitiveWritableObject(Object property) {
            return new IntWritable(((EntityProperty)property).getValueAsInteger());
        }

        public int get(Object value) {
            return (Integer)value;
        }
    }
}

