/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.hadoop.azure.hive;

import com.microsoft.hadoop.azure.hive.PrimitiveField;
import com.microsoft.windowsazure.storage.table.DynamicTableEntity;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class EntityObjectInspector
extends StructObjectInspector {
    private final List<PrimitiveField> fields;

    EntityObjectInspector(List<PrimitiveField> fields) {
        this.fields = fields;
    }

    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.STRUCT;
    }

    public String getTypeName() {
        return "entity";
    }

    public List<? extends StructField> getAllStructFieldRefs() {
        return this.fields;
    }

    public Object getStructFieldData(Object data, StructField fieldRef) {
        if (data == null) {
            return null;
        }
        return ((PrimitiveField)fieldRef).getData((DynamicTableEntity)data);
    }

    public StructField getStructFieldRef(String fieldName) {
        for (PrimitiveField f : this.fields) {
            if (!f.getFieldName().equalsIgnoreCase(fieldName)) continue;
            return f;
        }
        return null;
    }

    public List<Object> getStructFieldsDataAsList(Object data) {
        DynamicTableEntity entity = (DynamicTableEntity)data;
        ArrayList<Object> ret = new ArrayList<Object>(this.fields.size());
        for (PrimitiveField f : this.fields) {
            ret.add(f.getData(entity));
        }
        return ret;
    }
}

