/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.hadoop.azure.hive;

import com.microsoft.hadoop.azure.AzureTableConfiguration;
import com.microsoft.hadoop.azure.hive.AzureEntitySerDe;
import com.microsoft.hadoop.azure.oldinterface.OldAzureTableInputFormat;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.ql.io.FSRecordWriter;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.util.Progressable;

public class AzureTableHiveStorageHandler
extends Configured
implements HiveStorageHandler {
    private static void transferProperty(Properties tableProperties, Map<String, String> jobProperties, AzureTableConfiguration.Keys propertyToTransfer, boolean required) {
        String value = tableProperties.getProperty(propertyToTransfer.getKey());
        if (value != null) {
            jobProperties.put(propertyToTransfer.getKey(), value);
        } else if (required) {
            throw new IllegalArgumentException("Property " + propertyToTransfer.getKey() + " not found in the table properties.");
        }
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        Properties tableProperties = tableDesc.getProperties();
        AzureTableHiveStorageHandler.transferProperty(tableProperties, jobProperties, AzureTableConfiguration.Keys.TABLE_NAME, true);
        AzureTableHiveStorageHandler.transferProperty(tableProperties, jobProperties, AzureTableConfiguration.Keys.ACCOUNT_URI, true);
        AzureTableHiveStorageHandler.transferProperty(tableProperties, jobProperties, AzureTableConfiguration.Keys.STORAGE_KEY, true);
        AzureTableHiveStorageHandler.transferProperty(tableProperties, jobProperties, AzureTableConfiguration.Keys.PARTITIONER_CLASS, false);
        AzureTableHiveStorageHandler.transferProperty(tableProperties, jobProperties, AzureTableConfiguration.Keys.REQUIRE_FIELD_EXISTS, false);
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
    }

    @Deprecated
    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        throw new AssertionError((Object)"Shouldn't be called.");
    }

    public HiveAuthorizationProvider getAuthorizationProvider() throws HiveException {
        return null;
    }

    public Class<? extends InputFormat> getInputFormatClass() {
        return OldAzureTableInputFormat.class;
    }

    public HiveMetaHook getMetaHook() {
        return null;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return NotImplementedOutputFormat.class;
    }

    public Class<? extends AbstractSerDe> getSerDeClass() {
        return AzureEntitySerDe.class;
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
    }

    public static class NotImplementedOutputFormat
    implements HiveOutputFormat {
        public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
            throw new NotImplementedException();
        }

        public RecordWriter getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
            throw new NotImplementedException();
        }

        public FSRecordWriter getHiveRecordWriter(JobConf job, Path finalOutPath, Class valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
            throw new NotImplementedException();
        }
    }
}

