/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.hadoop.azure.hive;

import com.microsoft.hadoop.azure.AzureTableConfiguration;
import com.microsoft.hadoop.azure.WritableEntity;
import com.microsoft.hadoop.azure.hive.EntityObjectInspector;
import com.microsoft.hadoop.azure.hive.EntityPropertyInspector;
import com.microsoft.hadoop.azure.hive.PrimitiveField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;

public class AzureEntitySerDe
extends AbstractSerDe {
    private EntityObjectInspector objectInspector;

    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        List<String> columnNames = Arrays.asList(columnNameProperty.split(","));
        ArrayList columnTypes = TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
        if (columnNames.size() != columnTypes.size()) {
            throw new IllegalArgumentException("Column names list: " + columnNames + " doesn't match column types list: " + columnTypes);
        }
        ArrayList<PrimitiveField> fields = new ArrayList<PrimitiveField>(columnNames.size());
        boolean requireFieldExists = conf.getBoolean(AzureTableConfiguration.Keys.REQUIRE_FIELD_EXISTS.getKey(), false);
        for (int c = 0; c < columnNames.size(); ++c) {
            fields.add(new PrimitiveField(columnNames.get(c), EntityPropertyInspector.getInspectorForType(((TypeInfo)columnTypes.get(c)).getTypeName()), requireFieldExists));
        }
        this.objectInspector = new EntityObjectInspector(fields);
    }

    public Object deserialize(Writable blob) throws SerDeException {
        return blob;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.objectInspector;
    }

    public SerDeStats getSerDeStats() {
        return null;
    }

    public Class<? extends Writable> getSerializedClass() {
        return WritableEntity.class;
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        return (WritableEntity)((Object)obj);
    }
}

