/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.hadoop.azure.examples;

import com.microsoft.hadoop.azure.AzureTableConfiguration;
import com.microsoft.hadoop.azure.AzureTableInputFormat;
import com.microsoft.hadoop.azure.WritableEntity;
import com.microsoft.windowsazure.storage.StorageCredentials;
import com.microsoft.windowsazure.storage.StorageCredentialsAccountAndKey;
import com.microsoft.windowsazure.storage.table.CloudTable;
import com.microsoft.windowsazure.storage.table.CloudTableClient;
import com.microsoft.windowsazure.storage.table.DynamicTableEntity;
import com.microsoft.windowsazure.storage.table.EntityProperty;
import com.microsoft.windowsazure.storage.table.TableBatchOperation;
import com.microsoft.windowsazure.storage.table.TableEntity;
import com.microsoft.windowsazure.storage.table.TableOperation;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class SixCounter
extends Configured
implements Tool {
    private static final long NUM_PARTITIONS = 5L;
    private static final long NUM_ROWS_PER_PARTITION = 1000L;
    private static final long MAX_ROWS_PER_BATCH = 100L;
    private String accountName;
    private String accountKey;
    private URI accountUri;

    private static TableEntity newEntity(String partitionKey, String rowKey, long data) {
        HashMap<String, EntityProperty> properties = new HashMap<String, EntityProperty>();
        properties.put("data", new EntityProperty(data));
        DynamicTableEntity ret = new DynamicTableEntity(properties);
        ret.setPartitionKey(partitionKey);
        ret.setRowKey(rowKey);
        return ret;
    }

    private static void populate(CloudTable t) throws Exception {
        Random rand = new Random();
        int partition = 0;
        while ((long)partition < 5L) {
            TableBatchOperation batch = new TableBatchOperation();
            int rowsInBatch = 0;
            int row = 0;
            while ((long)row < 1000L) {
                batch.add(TableOperation.insert((TableEntity)SixCounter.newEntity("p" + partition, "r" + row, rand.nextInt(100))));
                if ((long)(++rowsInBatch) >= 100L) {
                    t.execute(batch);
                    batch = new TableBatchOperation();
                    rowsInBatch = 0;
                }
                ++row;
            }
            if (rowsInBatch > 0) {
                t.execute(batch);
            }
            ++partition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        CloudTable t = this.createTableReference(args);
        if (t == null) {
            return 1;
        }
        t.create();
        try {
            System.out.printf("Populating %d partitions each with %d rows...\n", 5L, 1000L);
            SixCounter.populate(t);
            System.out.println("Done!");
            Path output = new Path("sixCounterOut");
            FileSystem fs = FileSystem.get((Configuration)this.getConf());
            fs.delete(output, true);
            Job job = this.configureJob(t, output);
            job.submit();
            if (job.waitForCompletion(true)) {
                if (!this.displayResults(output, fs)) {
                    int n = 2;
                    return n;
                }
            } else {
                int n = 3;
                return n;
            }
            fs.delete(output, true);
        }
        finally {
            t.delete();
        }
        return 0;
    }

    private Job configureJob(CloudTable t, Path outputPath) throws IOException {
        Job job = Job.getInstance((Configuration)this.getConf());
        AzureTableConfiguration.configureInputTable(job.getConfiguration(), t.getName(), this.accountUri, this.accountKey);
        job.setJarByClass(((Object)((Object)this)).getClass());
        job.setMapperClass(SixFinderMapper.class);
        job.setCombinerClass(TallyReducer.class);
        job.setReducerClass(TallyReducer.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(LongWritable.class);
        job.setInputFormatClass(AzureTableInputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        return job;
    }

    private boolean displayResults(Path output, FileSystem fs) throws IOException {
        FileStatus[] reduceOutputs = fs.globStatus(new Path(output, "part-r-*"));
        if (reduceOutputs.length == 0) {
            System.err.println("No outputs found.");
            return false;
        }
        for (FileStatus singleOutput : reduceOutputs) {
            String line;
            FSDataInputStream in = fs.open(singleOutput.getPath());
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in));
            long sum = 0L;
            while ((line = reader.readLine()) != null) {
                long current = Long.parseLong(line.split("\t")[1]);
                sum += current;
            }
            reader.close();
            in.close();
            System.out.printf("There were %d sixes in the table.\n", sum);
        }
        return true;
    }

    private CloudTable createTableReference(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.printf("Usage: hadoop jar <jarPath> %s <accountName> <accountKey>\n", ((Object)((Object)this)).getClass().getName());
            return null;
        }
        this.accountName = args[0];
        this.accountKey = args[1];
        String tableName = "s" + UUID.randomUUID().toString().replace('-', 'd');
        StorageCredentialsAccountAndKey creds = new StorageCredentialsAccountAndKey(this.accountName, this.accountKey);
        this.accountUri = new URI(String.format("http://%s.table.core.windows.net/", this.accountName));
        CloudTableClient tableClient = new CloudTableClient(this.accountUri, (StorageCredentials)creds);
        return tableClient.getTableReference(tableName);
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new SixCounter(), (String[])args);
    }

    public static class TallyReducer
    extends Reducer<IntWritable, LongWritable, IntWritable, LongWritable> {
        private final LongWritable sum = new LongWritable();

        protected void reduce(IntWritable key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long currentSum = 0L;
            for (LongWritable c : values) {
                currentSum += c.get();
            }
            this.sum.set(currentSum);
            context.write((Object)key, (Object)this.sum);
        }
    }

    public static class SixFinderMapper
    extends Mapper<Text, WritableEntity, IntWritable, LongWritable> {
        private static final IntWritable SIX = new IntWritable(6);
        private static final LongWritable ONE = new LongWritable(1L);

        protected void map(Text key, WritableEntity value, Mapper.Context context) throws IOException, InterruptedException {
            long currentData = ((EntityProperty)value.getProperties().get("data")).getValueAsLong();
            if (currentData == 6L) {
                context.write((Object)SIX, (Object)ONE);
            }
        }
    }
}

