/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.hadoop.azure;

import com.microsoft.windowsazure.storage.table.DynamicTableEntity;
import com.microsoft.windowsazure.storage.table.EntityProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.io.Writable;

public class WritableEntity
extends DynamicTableEntity
implements Writable {
    public void readFields(DataInput input) throws IOException {
        this.setPartitionKey(input.readUTF());
        this.setRowKey(input.readUTF());
        this.setTimestamp(new Date(input.readLong()));
        int numProperties = input.readInt();
        HashMap<String, EntityProperty> properties = new HashMap<String, EntityProperty>();
        for (int i = 0; i < numProperties; ++i) {
            properties.put(input.readUTF(), new EntityProperty(input.readUTF()));
        }
        this.setProperties(properties);
    }

    public void write(DataOutput output) throws IOException {
        output.writeUTF(this.getPartitionKey());
        output.writeUTF(this.getRowKey());
        output.writeLong(this.getTimestamp().getTime());
        HashMap properties = this.getProperties();
        output.writeInt(properties.size());
        for (Map.Entry current : properties.entrySet()) {
            output.writeUTF((String)current.getKey());
            output.writeUTF(((EntityProperty)current.getValue()).getValueAsString());
        }
    }
}

