/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.hadoop.azure;

import com.microsoft.hadoop.azure.AzureTableInputSplit;
import com.microsoft.hadoop.azure.BaseAzureTablePartitioner;
import com.microsoft.hadoop.azure.PartitionInputSplit;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.table.CloudTable;
import com.microsoft.windowsazure.storage.table.DynamicTableEntity;
import com.microsoft.windowsazure.storage.table.TableQuery;
import java.util.ArrayList;
import java.util.List;

public class DefaultTablePartitioner
extends BaseAzureTablePartitioner {
    @Override
    public List<AzureTableInputSplit> getSplits(CloudTable table) throws StorageException {
        ArrayList<AzureTableInputSplit> ret = new ArrayList<AzureTableInputSplit>();
        List<String> partitionKeys = DefaultTablePartitioner.getAllPartitionKeys(table);
        for (String currentPartitionKey : partitionKeys) {
            ret.add(new PartitionInputSplit(currentPartitionKey));
        }
        return ret;
    }

    static List<String> getAllPartitionKeys(CloudTable table) throws StorageException {
        DynamicTableEntity currentEntity;
        TableQuery getNextKeyQuery = DefaultTablePartitioner.getFirstRowNoFields();
        ArrayList<String> ret = new ArrayList<String>();
        while ((currentEntity = DefaultTablePartitioner.GetSingleton(table.execute(getNextKeyQuery))) != null) {
            ret.add(currentEntity.getPartitionKey());
            getNextKeyQuery = DefaultTablePartitioner.getFirstRowNoFields().where("PartitionKey gt '" + currentEntity.getPartitionKey() + "'");
        }
        return ret;
    }
}

