/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.hadoop.azure;

import com.microsoft.hadoop.azure.AzureTableConfiguration;
import com.microsoft.hadoop.azure.AzureTableInputSplit;
import com.microsoft.hadoop.azure.WritableEntity;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.table.CloudTableClient;
import com.microsoft.windowsazure.storage.table.TableQuery;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class AzureTableRecordReader
extends RecordReader<Text, WritableEntity> {
    private Iterator<WritableEntity> queryResults;
    private WritableEntity currentEntity;
    private Text currentKey = new Text();

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration job = context.getConfiguration();
        CloudTableClient tableClient = AzureTableConfiguration.createTableClient(job);
        String tableName = AzureTableConfiguration.getTableName(job);
        TableQuery<WritableEntity> query = ((AzureTableInputSplit)split).getQuery();
        try {
            this.queryResults = tableClient.getTableReference(tableName).execute(query).iterator();
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.queryResults.hasNext()) {
            this.currentEntity = this.queryResults.next();
            this.currentKey.set(this.currentEntity.getRowKey());
            return true;
        }
        this.currentEntity = null;
        return false;
    }

    public Text getCurrentKey() throws IOException, InterruptedException {
        if (this.currentEntity == null) {
            return null;
        }
        return this.currentKey;
    }

    public WritableEntity getCurrentValue() throws IOException, InterruptedException {
        return this.currentEntity;
    }

    public float getProgress() throws IOException, InterruptedException {
        return 0.5f;
    }

    public void close() throws IOException {
    }
}

