/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.hadoop.azure;

import com.microsoft.hadoop.azure.AzureTableConfiguration;
import com.microsoft.hadoop.azure.AzureTableInputSplit;
import com.microsoft.hadoop.azure.AzureTablePartitioner;
import com.microsoft.hadoop.azure.AzureTableRecordReader;
import com.microsoft.hadoop.azure.WritableEntity;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.table.CloudTable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class AzureTableInputFormat
extends InputFormat<Text, WritableEntity> {
    public RecordReader<Text, WritableEntity> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new AzureTableRecordReader();
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        Configuration job = context.getConfiguration();
        AzureTablePartitioner partitioner = AzureTableConfiguration.getPartitioner(job);
        partitioner.configure(job);
        CloudTable table = AzureTableConfiguration.getTableReference(job);
        ArrayList<InputSplit> ret = new ArrayList<InputSplit>();
        try {
            for (AzureTableInputSplit split : partitioner.getSplits(table)) {
                ret.add(split);
            }
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
        return ret;
    }
}

