/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.hadoop.azure;

import com.microsoft.hadoop.azure.AzureTablePartitioner;
import com.microsoft.hadoop.azure.DefaultTablePartitioner;
import com.microsoft.windowsazure.storage.StorageCredentials;
import com.microsoft.windowsazure.storage.StorageCredentialsAccountAndKey;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.table.CloudTable;
import com.microsoft.windowsazure.storage.table.CloudTableClient;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;

public class AzureTableConfiguration {
    public static void configureInputTable(Configuration conf, String tableName, URI accountUri, String storageKey) {
        conf.set(Keys.TABLE_NAME.getKey(), tableName);
        conf.set(Keys.ACCOUNT_URI.getKey(), accountUri.toString());
        conf.set(Keys.STORAGE_KEY.getKey(), storageKey);
    }

    public static String getTableName(Configuration conf) {
        return conf.get(Keys.TABLE_NAME.getKey());
    }

    public static AzureTablePartitioner getPartitioner(Configuration job) throws IOException {
        Class partitionerClass = job.getClass(Keys.PARTITIONER_CLASS.getKey(), DefaultTablePartitioner.class, AzureTablePartitioner.class);
        try {
            return (AzureTablePartitioner)partitionerClass.newInstance();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static CloudTable getTableReference(Configuration job) throws IOException {
        CloudTableClient tableClient = AzureTableConfiguration.createTableClient(job);
        String tableName = AzureTableConfiguration.getTableName(job);
        try {
            return tableClient.getTableReference(tableName);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
    }

    public static CloudTableClient createTableClient(Configuration job) throws IOException {
        URI accountUri;
        String accountUriString = job.get(Keys.ACCOUNT_URI.getKey());
        if (accountUriString == null) {
            throw new IllegalArgumentException(Keys.ACCOUNT_URI.getKey() + " not specified.");
        }
        String storageKey = job.get(Keys.STORAGE_KEY.getKey());
        if (storageKey == null) {
            throw new IllegalArgumentException(Keys.STORAGE_KEY.getKey() + " not specified.");
        }
        try {
            accountUri = new URI(accountUriString);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(String.format("Invalid value specified for %s: %s", new Object[]{Keys.ACCOUNT_URI, accountUriString}), ex);
        }
        String accountName = accountUri.getAuthority().split("\\.")[0];
        StorageCredentialsAccountAndKey creds = new StorageCredentialsAccountAndKey(accountName, storageKey);
        return new CloudTableClient(accountUri, (StorageCredentials)creds);
    }

    public static enum Keys {
        TABLE_NAME("azure.table.name"),
        ACCOUNT_URI("azure.table.account.uri"),
        STORAGE_KEY("azure.table.storage.key"),
        PARTITIONER_CLASS("azure.table.partitioner.class"),
        REQUIRE_FIELD_EXISTS("azure.table.require.field.exists");

        private final String key;

        private Keys(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

