/*
 * Decompiled with CFR 0.152.
 */
package ca.bin.training.hive.udf;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

public final class CalHolidaysGap
extends UDF {
    String[] holidays = new String[]{"01/01/2007", "01/15/2007", "02/19/2007", "05/28/2007", "06/07/2007", "07/04/2007", "09/03/2007", "10/08/2007", "11/11/2007", "11/22/2007", "12/25/2007", "01/01/2008", "01/21/2008", "02/18/2008", "05/22/2008", "05/26/2008", "07/04/2008", "09/01/2008", "10/13/2008", "11/11/2008", "11/27/2008", "12/25/2008"};
    DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");

    public LongWritable evaluate(IntWritable year, IntWritable month, IntWritable day) {
        Calendar start = Calendar.getInstance();
        start.set(year.get(), month.get(), day.get());
        long startTime = start.getTime().getTime();
        long endTime = 0L;
        Date end = null;
        long diffDays = 3000L;
        for (String holiday : this.holidays) {
            try {
                end = this.dateFormat.parse(holiday);
            }
            catch (Exception exception) {
                // empty catch block
            }
            endTime = end.getTime();
            long diffTime = Math.abs(endTime - startTime);
            if (diffDays <= diffTime / 86400000L) continue;
            diffDays = Math.round(diffTime / 86400000L);
        }
        return new LongWritable(diffDays);
    }
}

