/*
 * Decompiled with CFR 0.152.
 */
package ca.training.bigdata.mr.kmeans;

import ca.training.bigdata.mr.kmeans.KMeansCentroid;
import ca.training.bigdata.mr.kmeans.KMeansCombiner;
import ca.training.bigdata.mr.kmeans.KMeansMapper;
import ca.training.bigdata.mr.kmeans.KMeansPartitioner;
import ca.training.bigdata.mr.kmeans.KMeansPoint;
import ca.training.bigdata.mr.kmeans.KMeansReducer;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class KMeansStep
extends Job {
    public KMeansStep(Configuration conf) throws IOException {
        super(conf);
        this.setJarByClass(((Object)((Object)this)).getClass());
        this.addCacheFiles();
        FileOutputFormat.setOutputPath((Job)this, (Path)this.getOutputPath());
        FileInputFormat.addInputPath((Job)this, (Path)this.getInputPath());
        this.setMapperClass(KMeansMapper.class);
        this.setCombinerClass(KMeansCombiner.class);
        this.setPartitionerClass(KMeansPartitioner.class);
        this.setReducerClass(KMeansReducer.class);
        this.setMapOutputKeyClass(KMeansCentroid.class);
        this.setMapOutputValueClass(KMeansPoint.class);
        this.setOutputKeyClass(Text.class);
        this.setOutputValueClass(NullWritable.class);
        this.setNumReduceTasks(conf.getInt("number", this.getNumReduceTasks()));
    }

    public Boolean run() {
        Path output = this.getOutputPath();
        try {
            FileSystem dfs = FileSystem.get((Configuration)this.getConfiguration());
            if (dfs.isDirectory(output)) {
                dfs.delete(output, true);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Boolean result = false;
        try {
            result = this.waitForCompletion(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Boolean retry() {
        return this.run();
    }

    private Path getOutputPath() {
        String sep = System.getProperty("file.separator");
        System.out.println("Using output " + this.conf.get("output") + sep + this.conf.get("iteration"));
        return new Path(this.conf.get("output") + sep + String.valueOf(this.conf.getInt("iteration", 0)));
    }

    private Path getInputPath() {
        System.out.println("Using input " + this.conf.get("input"));
        return new Path(this.conf.get("input"));
    }

    private void addCacheFiles() throws IOException {
        Integer iteration = this.conf.getInt("iteration", 0);
        if (iteration > 1) {
            FileStatus[] ls;
            String sep = System.getProperty("file.separator");
            String output = this.conf.get("output") + sep + String.valueOf(this.conf.getInt("iteration", 0) - 1);
            Path out = new Path(output, "part-r-[0-9]*");
            System.out.println("Checking path " + out.toString());
            FileSystem fs = FileSystem.get((Configuration)this.conf);
            for (FileStatus fileStatus : ls = fs.globStatus(out)) {
                Path pfs = fileStatus.getPath();
                System.out.println("Adding " + pfs.toUri().toString());
                this.addCacheFile(pfs.toUri());
            }
        } else {
            Path pfs = new Path(this.conf.get("state"));
            System.out.println("First iteration adding " + pfs.toUri().toString());
            this.addCacheFile(pfs.toUri());
        }
    }
}

