/*
 * Decompiled with CFR 0.152.
 */
package ca.training.bigdata.mr.kmeans;

import ca.training.bigdata.mr.kmeans.KMeansCentroid;
import ca.training.bigdata.mr.kmeans.KMeansCounters;
import ca.training.bigdata.mr.kmeans.KMeansPoint;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Reducer;

public class KMeansReducer
extends Reducer<KMeansCentroid, KMeansPoint, Text, NullWritable> {
    private Double delta = 0.0;
    private Text outKey = new Text();
    private Counter adjusted;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        this.adjusted = context.getCounter((Enum)KMeansCounters.ADJUSTED);
        Configuration conf = context.getConfiguration();
        this.delta = conf.getDouble("delta", 0.0);
    }

    public void reduce(KMeansCentroid key, Iterable<KMeansPoint> points, Reducer.Context context) throws IOException, InterruptedException {
        try {
            KMeansCentroid newKey = KMeansCentroid.calculate(key.getText(), points);
            double similarity = key.distance(newKey);
            if (similarity > this.delta) {
                this.adjusted.increment(1L);
            }
            this.outKey.set(newKey.toString());
            context.write((Object)this.outKey, (Object)NullWritable.get());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

