/*
 * Decompiled with CFR 0.152.
 */
package ca.training.bigdata.mr.kmeans;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.ArrayPrimitiveWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;

public class KMeansPoint
implements Writable {
    private ArrayPrimitiveWritable vector = new ArrayPrimitiveWritable();
    private IntWritable number = new IntWritable(0);

    public KMeansPoint parse(String value) {
        String[] coords = value.toString().split(",");
        double[] temp = new double[coords.length];
        int j = temp.length;
        for (int i = 0; i < j; ++i) {
            temp[i] = Double.valueOf(coords[i]);
        }
        this.vector.set((Object)temp);
        this.number.set(1);
        return this;
    }

    public double[] getVector() {
        return (double[])this.vector.get();
    }

    public void setVector(double[] temp) {
        this.vector.set((Object)temp);
    }

    public void readFields(DataInput in) throws IOException {
        this.vector.readFields(in);
        this.number.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        this.vector.write(out);
        this.number.write(out);
    }

    public int getDimensions() {
        return this.getVector().length;
    }

    public double distance(KMeansPoint point) {
        this.getVector();
        double sum = 0.0;
        double[] thisVector = this.getVector();
        double[] otherVector = point.getVector();
        if (thisVector.length != otherVector.length) {
            throw new RuntimeException();
        }
        int j = thisVector.length;
        for (int i = 0; i < j; ++i) {
            double thisCoordinate = thisVector[i];
            double otherCoordinate = otherVector[i];
            sum += Math.pow(thisCoordinate - otherCoordinate, 2.0);
        }
        return Math.sqrt(sum);
    }

    public void add(double[] otherVector, int nums) {
        double[] thisVector = this.getVector();
        int j = thisVector.length;
        for (int i = 0; i < j; ++i) {
            thisVector[i] = thisVector[i] + otherVector[i];
        }
        this.number.set(this.number.get() + nums);
        this.setVector(thisVector);
    }

    public void compress() {
        double[] thisVector = this.getVector();
        double currentNumber = this.number.get();
        int i = 0;
        int j = thisVector.length;
        while (i < j) {
            int n = i++;
            thisVector[n] = thisVector[n] / currentNumber;
        }
        this.number.set(1);
        this.setVector(thisVector);
    }

    public String toString() {
        double[] thisVector = this.getVector();
        StringBuffer sb = new StringBuffer();
        int j = thisVector.length;
        for (int i = 0; i < j; ++i) {
            sb.append(thisVector[i]);
            if (i >= thisVector.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public double getNumber() {
        return this.number.get();
    }

    public boolean equals(Object o) {
        if (o instanceof KMeansPoint) {
            KMeansPoint p = (KMeansPoint)o;
            return Arrays.equals(this.getVector(), p.getVector());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getVector());
    }

    public void setNumber(int i) {
        this.number.set(i);
    }
}

