/*
 * Decompiled with CFR 0.152.
 */
package ca.training.bigdata.mr.kmeans;

import ca.training.bigdata.mr.kmeans.KMeansCentroid;
import ca.training.bigdata.mr.kmeans.KMeansManager;
import ca.training.bigdata.mr.kmeans.KMeansPoint;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class KMeansMapper
extends Mapper<LongWritable, Text, KMeansCentroid, KMeansPoint> {
    private KMeansPoint point = new KMeansPoint();
    private KMeansManager manager = null;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.manager = new KMeansManager();
        List<URI> uris = Arrays.asList(context.getCacheFiles());
        for (URI uri : uris) {
            Path p = new Path(uri);
            FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
            InputStreamReader ir = new InputStreamReader((InputStream)fs.open(p));
            BufferedReader br = new BufferedReader(ir);
            String line = br.readLine();
            while (line != null) {
                this.manager.add(line);
                line = br.readLine();
            }
        }
    }

    public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        try {
            this.point.parse(value.toString());
            context.write((Object)this.manager.closest(this.point), (Object)this.point);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

