/*
 * Decompiled with CFR 0.152.
 */
package ca.training.bigdata.mr.kmeans;

import ca.training.bigdata.mr.kmeans.KMeansCentroid;
import ca.training.bigdata.mr.kmeans.KMeansPoint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class KMeansManager {
    private List<KMeansCentroid> centroids = new ArrayList<KMeansCentroid>();

    public KMeansCentroid add(String record) {
        KMeansCentroid centroid = new KMeansCentroid().parse(record);
        return this.add(centroid);
    }

    public KMeansCentroid add(KMeansCentroid centroid) {
        this.centroids.add(centroid);
        return centroid;
    }

    public KMeansCentroid closest(KMeansPoint point) {
        KMeansCentroid closest = null;
        if (this.centroids.size() > 0) {
            closest = this.centroids.get(0);
            double minDist = closest.distance(point);
            for (KMeansCentroid centroid : this.centroids) {
                double dist = centroid.distance(point);
                if (!(minDist >= dist)) continue;
                closest = centroid;
                minDist = dist;
            }
        }
        return closest;
    }
}

