/*
 * Decompiled with CFR 0.152.
 */
package ca.training.bigdata.mr.kmeans;

import ca.training.bigdata.mr.kmeans.KMeansController;
import ca.training.bigdata.mr.kmeans.KMeansStep;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class KMeansDriver
extends Configured
implements Tool {
    private static final String USAGE = "USAGE %s: home input clusters number output delta max\n";

    public int run(String[] args) throws Exception {
        if (args.length < 6) {
            System.err.printf(USAGE, ((Object)((Object)this)).getClass());
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
            return 1;
        }
        Configuration conf = this.getConf();
        conf.set("home", String.valueOf(args[0]));
        conf.set("input", String.valueOf(args[1]));
        conf.set("state", String.valueOf(args[2]));
        conf.setInt("number", Integer.valueOf(args[3]).intValue());
        conf.set("output", String.valueOf(args[4]));
        conf.setDouble("delta", Double.valueOf(args[5]).doubleValue());
        conf.setInt("max", Integer.valueOf(args[6]).intValue());
        KMeansController kmeans = new KMeansController(conf);
        kmeans.resurrect();
        while (!kmeans.converged().booleanValue()) {
            KMeansStep step = kmeans.step();
            System.out.printf("Starting Iteration %s\n", kmeans.getIteration());
            boolean result = step.run();
            if (!result && !step.retry().booleanValue()) {
                throw new Exception("Iteration failed!");
            }
            if (kmeans.commit().booleanValue()) continue;
            throw new Exception("Unable to commit iteration state!");
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Tool)new KMeansDriver(), (String[])args);
        System.exit(exitCode);
    }
}

