/*
 * Decompiled with CFR 0.152.
 */
package ca.training.bigdata.mr.kmeans;

import ca.training.bigdata.mr.kmeans.KMeansCounters;
import ca.training.bigdata.mr.kmeans.KMeansStep;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;

public class KMeansController {
    private Integer iteration = 0;
    private KMeansStep previousStep = null;
    private KMeansStep currentStep = null;
    private Configuration conf = null;

    public KMeansController(Configuration conf) {
        this.conf = conf;
        this.iteration = this.conf.getInt("iteration", 0);
    }

    public KMeansStep step() {
        try {
            Integer n = this.iteration;
            Integer n2 = this.iteration = Integer.valueOf(this.iteration + 1);
            this.conf.setInt("iteration", this.iteration.intValue());
            KMeansStep tempStep = new KMeansStep(this.conf);
            this.previousStep = this.currentStep;
            this.currentStep = tempStep;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.currentStep;
    }

    public Boolean converged() {
        Boolean result = false;
        if (null != this.currentStep) {
            Integer max = this.conf.getInt("max", 0);
            if (this.getIteration() < max) {
                try {
                    Counters counters = this.currentStep.getCounters();
                    KMeansCounters convergedCounter = KMeansCounters.ADJUSTED;
                    Counter counter = counters.findCounter((Enum)convergedCounter);
                    result = 0L == counter.getValue();
                    System.out.printf("Algorithm counter %s == %s\n", 0, counter.getValue());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                System.out.printf("Algorithm converged max iterations\n", new Object[0]);
                result = true;
            }
        }
        return result;
    }

    public Boolean commit() {
        try {
            Path homePath = new Path(this.conf.get("home"));
            FileSystem dfs = FileSystem.get((Configuration)new Configuration());
            if (!dfs.isFile(homePath)) {
                dfs.createNewFile(homePath);
            }
            FSDataOutputStream dfsOutput = dfs.create(homePath);
            this.conf.write((DataOutput)dfsOutput);
            dfs.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Boolean resurrect() {
        try {
            Path homePath = new Path(this.conf.get("home"));
            FileSystem dfs = FileSystem.get((Configuration)new Configuration());
            if (dfs.isFile(homePath)) {
                FSDataInputStream dfsInput = dfs.open(homePath);
                this.conf.readFields((DataInput)dfsInput);
            }
            dfs.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Integer getIteration() {
        return this.iteration;
    }

    public KMeansStep previousStep() {
        return this.previousStep;
    }

    public KMeansStep currentStep() {
        return this.currentStep;
    }
}

