/*
 * Decompiled with CFR 0.152.
 */
package ca.training.bigdata.mr.kmeans;

import ca.training.bigdata.mr.kmeans.KMeansCentroid;
import ca.training.bigdata.mr.kmeans.KMeansPoint;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.mapreduce.Reducer;

public class KMeansCombiner
extends Reducer<KMeansCentroid, KMeansPoint, KMeansCentroid, KMeansPoint> {
    public void reduce(KMeansCentroid key, Iterable<KMeansPoint> points, Reducer.Context context) throws IOException, InterruptedException {
        KMeansPoint result = null;
        for (KMeansPoint point : points) {
            int count = Double.valueOf(point.getNumber()).intValue();
            double[] vector = point.getVector();
            double[] temp = Arrays.copyOf(vector, vector.length);
            if (null == result) {
                result = new KMeansPoint();
                result.setVector(temp);
                result.setNumber(count);
                continue;
            }
            result.add(temp, count);
        }
        if (null != result) {
            context.write((Object)key, result);
        }
    }
}

