/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka.demoproducer;

import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.hive.kafka.demoproducer.BaseProducer;

public class DemoProducer {
    public static void main(String[] args) {
        Properties props = new Properties();
        String topic = args[0];
        int iters = Integer.parseInt(args[1]);
        props.put("metadata.broker.list", args[2]);
        props.put("request.required.acks", "-1");
        props.put("serializer.class", "kafka.serializer.DefaultEncoder");
        props.put("key.serializer.class", "kafka.serializer.StringEncoder");
        props.put("producer.type", "sync");
        BaseProducer demo = new BaseProducer(props);
        Schema schema = new Schema.Parser().parse("{\n\t\"type\":\"record\",\n\t\"name\":\"test_schema_1\",\n\t\"fields\" : [ {\n\t\t\"name\":\"a\",\n\t\t\"type\":\"int\"\n\t\t},\n\t\t{\n\t\t\"name\":\"b\",\n\t\t\"type\":\"string\"\n\t\t}\n\t\t]\n}");
        GenericData.Record event = new GenericData.Record(schema);
        for (int i = 1; i < iters; ++i) {
            event.put("a", (Object)i);
            event.put("b", (Object)"static string");
            demo.publish((GenericRecord)event, topic, schema);
        }
        demo.close();
    }
}

