/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka.demoproducer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.commons.io.IOUtils;

public class BaseProducer {
    private final Producer<String, byte[]> kafkaProducer;

    public BaseProducer(Properties props) {
        this.kafkaProducer = new Producer(new ProducerConfig(props));
    }

    public static byte[] serializeAvro(Schema schema, GenericRecord event) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        BinaryEncoder binaryEncoder = EncoderFactory.get().binaryEncoder((OutputStream)stream, null);
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        datumWriter.write((Object)event, (Encoder)binaryEncoder);
        binaryEncoder.flush();
        IOUtils.closeQuietly((OutputStream)stream);
        return stream.toByteArray();
    }

    public void publish(GenericRecord event, String topic, Schema schema) {
        try {
            byte[] m = BaseProducer.serializeAvro(schema, event);
            KeyedMessage km = new KeyedMessage(topic, (Object)m);
            this.kafkaProducer.send(km);
        }
        catch (IOException e) {
            throw new RuntimeException("Avro serialization failure", e);
        }
    }

    public void close() {
        this.kafkaProducer.close();
    }
}

