/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka.camus;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hive.kafka.camus.SchemaDetails;
import org.apache.hadoop.hive.kafka.camus.SchemaNotFoundException;
import org.apache.hadoop.hive.kafka.camus.SchemaRegistry;

public class MemorySchemaRegistry<S>
implements SchemaRegistry<S> {
    private final Map<MemorySchemaRegistryTuple, S> schemasById = new ConcurrentHashMap<MemorySchemaRegistryTuple, S>();
    private final Map<String, MemorySchemaRegistryTuple> latest = new ConcurrentHashMap<String, MemorySchemaRegistryTuple>();
    private final AtomicLong ids = new AtomicLong(0L);

    @Override
    public void init(Properties props) {
    }

    @Override
    public String register(String topic, S schema) {
        long id = this.ids.incrementAndGet();
        MemorySchemaRegistryTuple tuple = new MemorySchemaRegistryTuple(topic, id);
        this.schemasById.put(tuple, schema);
        this.latest.put(topic, tuple);
        return Long.toString(id);
    }

    @Override
    public S getSchemaByID(String topicName, String idStr) {
        try {
            S schema = this.schemasById.get(new MemorySchemaRegistryTuple(topicName, Long.parseLong(idStr)));
            if (schema == null) {
                throw new SchemaNotFoundException();
            }
            return schema;
        }
        catch (NumberFormatException e) {
            throw new SchemaNotFoundException("Supplied a non-long id string.", e);
        }
    }

    @Override
    public SchemaDetails<S> getLatestSchemaByTopic(String topicName) {
        MemorySchemaRegistryTuple tuple = this.latest.get(topicName);
        if (tuple == null) {
            throw new SchemaNotFoundException();
        }
        S schema = this.schemasById.get(tuple);
        if (schema == null) {
            throw new SchemaNotFoundException();
        }
        return new SchemaDetails<S>(topicName, Long.toString(tuple.getId()), schema);
    }

    public class MemorySchemaRegistryTuple {
        private final String topicName;
        private final long id;

        public MemorySchemaRegistryTuple(String topicName, long id) {
            this.topicName = topicName;
            this.id = id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (int)(this.id ^ this.id >>> 32);
            result = 31 * result + (this.topicName == null ? 0 : this.topicName.hashCode());
            return result;
        }

        public String getTopicName() {
            return this.topicName;
        }

        public long getId() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MemorySchemaRegistryTuple other = (MemorySchemaRegistryTuple)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.id != other.id) {
                return false;
            }
            return !(this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName));
        }

        private MemorySchemaRegistry getOuterType() {
            return MemorySchemaRegistry.this;
        }

        public String toString() {
            return "MemorySchemaRegistryTuple [topicName=" + this.topicName + ", id=" + this.id + "]";
        }
    }
}

