/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka.camus;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.kafka.camus.CamusRequest;
import org.apache.hadoop.hive.kafka.camus.KafkaRequest;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;

public class KafkaSplit
extends FileSplit {
    private List<CamusRequest> requests = new ArrayList<CamusRequest>();
    private long length = 0L;
    private String currentTopic = "";
    private Path path;

    public KafkaSplit() {
        this(new Path(" "));
    }

    public KafkaSplit(Path path) {
        super(path, 0L, 0L, (String[])null);
        this.path = path;
    }

    public void readFields(DataInput in) throws IOException {
        this.path = new Path(Text.readString((DataInput)in));
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            KafkaRequest r = new KafkaRequest();
            r.readFields(in);
            this.requests.add(r);
            this.length += r.estimateDataSize();
        }
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.path.toString());
        out.writeInt(this.requests.size());
        for (CamusRequest r : this.requests) {
            r.write(out);
        }
    }

    public long getLength() {
        return this.length;
    }

    public int getNumRequests() {
        return this.requests.size();
    }

    public String[] getLocations() throws IOException {
        return new String[0];
    }

    public void addRequest(CamusRequest request) {
        this.requests.add(request);
        this.length += request.estimateDataSize();
    }

    public CamusRequest popRequest() {
        if (this.requests.size() > 0) {
            for (int i = 0; i < this.requests.size(); ++i) {
                if (!this.requests.get(i).getTopic().equals(this.currentTopic)) continue;
                return this.requests.remove(i);
            }
            CamusRequest cr = this.requests.remove(this.requests.size() - 1);
            this.currentTopic = cr.getTopic();
            return cr;
        }
        return null;
    }

    public Path getPath() {
        return this.path;
    }
}

