/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka.camus;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.common.TopicAndPartition;
import kafka.javaapi.OffsetRequest;
import kafka.javaapi.OffsetResponse;
import kafka.javaapi.consumer.SimpleConsumer;
import org.apache.hadoop.hive.kafka.camus.CamusRequest;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.mapred.JobConf;
import org.apache.log4j.Logger;

public class KafkaRequest
implements CamusRequest {
    private static Logger log = Logger.getLogger(KafkaRequest.class);
    private JobConf conf = null;
    private static final long DEFAULT_OFFSET = 0L;
    private String topic = "";
    private String leaderId = "";
    private int partition = 0;
    private URI uri = null;
    private long offset = 0L;
    private long latestOffset = -1L;
    private long earliestOffset = -2L;
    private long avgMsgSize = 1024L;

    public KafkaRequest() {
    }

    public KafkaRequest(KafkaRequest other) {
        this.topic = other.topic;
        this.leaderId = other.leaderId;
        this.partition = other.partition;
        this.uri = other.uri;
        this.offset = other.offset;
        this.latestOffset = other.latestOffset;
        this.earliestOffset = other.earliestOffset;
        this.avgMsgSize = other.avgMsgSize;
    }

    @Override
    public void setLatestOffset(long latestOffset) {
        this.latestOffset = latestOffset;
    }

    @Override
    public void setEarliestOffset(long earliestOffset) {
        this.earliestOffset = earliestOffset;
    }

    @Override
    public void setAvgMsgSize(long size) {
        this.avgMsgSize = size;
    }

    public KafkaRequest(JobConf conf, String topic, String leaderId, int partition) {
        this(conf, topic, leaderId, partition, null, 0L);
    }

    public KafkaRequest(JobConf conf, String topic, String leaderId, int partition, URI brokerUri) {
        this(conf, topic, leaderId, partition, brokerUri, 0L);
    }

    public KafkaRequest(JobConf conf, String topic, String leaderId, int partition, URI brokerUri, long offset) {
        this.conf = conf;
        this.topic = topic;
        this.leaderId = leaderId;
        this.uri = brokerUri;
        this.partition = partition;
        this.setOffset(offset);
    }

    @Override
    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public void setURI(URI uri) {
        this.uri = uri;
    }

    public String getLeaderId() {
        return this.leaderId;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public int getPartition() {
        return this.partition;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    public void setLeaderId(String leaderId) {
        this.leaderId = leaderId;
    }

    @Override
    public boolean isValidOffset() {
        return this.offset >= 0L;
    }

    public String toString() {
        return this.topic + "\turi:" + (this.uri != null ? this.uri.toString() : "") + "\tleader:" + this.leaderId + "\tpartition:" + this.partition + "\tearliest_offset:" + this.getEarliestOffset() + "\toffset:" + this.offset + "\tlatest_offset:" + this.getLastOffset() + "\tavg_msg_size:" + this.avgMsgSize + "\testimated_size:" + this.estimateDataSize();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KafkaRequest)) {
            return false;
        }
        KafkaRequest that = (KafkaRequest)o;
        if (this.partition != that.partition) {
            return false;
        }
        return this.topic.equals(that.topic);
    }

    public int hashCode() {
        int result = this.topic.hashCode();
        result = 31 * result + this.partition;
        return result;
    }

    public CamusRequest clone() {
        return new KafkaRequest(this.conf, this.topic, this.leaderId, this.partition, this.uri, this.offset);
    }

    @Override
    public long getEarliestOffset() {
        if (this.earliestOffset == -2L && this.uri != null) {
            SimpleConsumer consumer = new SimpleConsumer(this.uri.getHost(), this.uri.getPort(), 60000, 0x100000, "hadoop-etl");
            HashMap<TopicAndPartition, PartitionOffsetRequestInfo> offsetInfo = new HashMap<TopicAndPartition, PartitionOffsetRequestInfo>();
            offsetInfo.put(new TopicAndPartition(this.topic, this.partition), new PartitionOffsetRequestInfo(kafka.api.OffsetRequest.EarliestTime(), 1));
            OffsetResponse response = consumer.getOffsetsBefore(new OffsetRequest(offsetInfo, kafka.api.OffsetRequest.CurrentVersion(), "hadoop-etl"));
            long[] endOffset = response.offsets(this.topic, this.partition);
            consumer.close();
            this.earliestOffset = endOffset[0];
            return endOffset[0];
        }
        return this.earliestOffset;
    }

    @Override
    public long getLastOffset() {
        if (this.latestOffset == -1L && this.uri != null) {
            return this.getLastOffset(kafka.api.OffsetRequest.LatestTime());
        }
        return this.latestOffset;
    }

    @Override
    public long getLastOffset(long time) {
        SimpleConsumer consumer = new SimpleConsumer(this.uri.getHost(), this.uri.getPort(), 60000, 0x100000, "hadoop-etl");
        HashMap<TopicAndPartition, PartitionOffsetRequestInfo> offsetInfo = new HashMap<TopicAndPartition, PartitionOffsetRequestInfo>();
        offsetInfo.put(new TopicAndPartition(this.topic, this.partition), new PartitionOffsetRequestInfo(time, 1));
        OffsetResponse response = consumer.getOffsetsBefore(new OffsetRequest(offsetInfo, kafka.api.OffsetRequest.CurrentVersion(), "hadoop-etl"));
        long[] endOffset = response.offsets(this.topic, this.partition);
        consumer.close();
        if (endOffset.length == 0) {
            log.info((Object)("The exception is thrown because the latest offset retunred zero for topic : " + this.topic + " and partition " + this.partition));
        }
        this.latestOffset = endOffset[0];
        return endOffset[0];
    }

    @Override
    public long estimateDataSize() {
        long endOffset = this.getLastOffset();
        return (endOffset - this.offset) * this.avgMsgSize;
    }

    @Override
    public long estimateDataSize(long endTime) {
        long endOffset = this.getLastOffset(endTime);
        return (endOffset - this.offset) * this.avgMsgSize;
    }

    public void readFields(DataInput in) throws IOException {
        this.topic = UTF8.readString((DataInput)in);
        this.leaderId = UTF8.readString((DataInput)in);
        String str = UTF8.readString((DataInput)in);
        if (!str.isEmpty()) {
            try {
                this.uri = new URI(str);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        this.partition = in.readInt();
        this.offset = in.readLong();
        this.latestOffset = in.readLong();
    }

    public void write(DataOutput out) throws IOException {
        UTF8.writeString((DataOutput)out, (String)this.topic);
        UTF8.writeString((DataOutput)out, (String)this.leaderId);
        if (this.uri != null) {
            UTF8.writeString((DataOutput)out, (String)this.uri.toString());
        } else {
            UTF8.writeString((DataOutput)out, (String)"");
        }
        out.writeInt(this.partition);
        out.writeLong(this.offset);
        out.writeLong(this.latestOffset);
    }
}

