/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka.camus;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import kafka.api.PartitionFetchInfo;
import kafka.common.TopicAndPartition;
import kafka.javaapi.FetchRequest;
import kafka.javaapi.FetchResponse;
import kafka.javaapi.consumer.SimpleConsumer;
import kafka.javaapi.message.ByteBufferMessageSet;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import org.apache.hadoop.hive.kafka.camus.KafkaKey;
import org.apache.hadoop.hive.kafka.camus.KafkaRequest;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;

public class KafkaReader {
    private static Logger log = Logger.getLogger(KafkaReader.class);
    private KafkaRequest kafkaRequest = null;
    private SimpleConsumer simpleConsumer = null;
    private long beginOffset;
    private long currentOffset;
    private long lastOffset;
    private long currentCount;
    private TaskAttemptContext context;
    private Iterator<MessageAndOffset> messageIter = null;
    private long totalFetchTime = 0L;
    private long lastFetchTime = 0L;
    private int fetchBufferSize;

    public KafkaReader(JobConf conf, KafkaRequest request, int clientTimeout, int fetchBufferSize) throws Exception {
        this.fetchBufferSize = fetchBufferSize;
        this.context = this.context;
        log.info((Object)("bufferSize=" + fetchBufferSize));
        log.info((Object)("timeout=" + clientTimeout));
        this.kafkaRequest = request;
        this.beginOffset = request.getOffset();
        this.currentOffset = request.getOffset();
        this.lastOffset = request.getLastOffset();
        this.currentCount = 0L;
        this.totalFetchTime = 0L;
        URI uri = this.kafkaRequest.getURI();
        this.simpleConsumer = new SimpleConsumer(uri.getHost(), uri.getPort(), 30000, 0x100000, "hive_kafka_client");
        log.info((Object)("Connected to leader " + uri + " beginning reading at offset " + this.beginOffset + " latest offset=" + this.lastOffset));
        this.fetch();
    }

    public boolean hasNext() throws IOException {
        if (this.messageIter != null && this.messageIter.hasNext()) {
            return true;
        }
        return this.fetch();
    }

    public boolean getNext(KafkaKey key, BytesWritable payload, BytesWritable pKey) throws IOException {
        if (this.hasNext()) {
            MessageAndOffset msgAndOffset = this.messageIter.next();
            Message message = msgAndOffset.message();
            ByteBuffer buf = message.payload();
            int origSize = buf.remaining();
            byte[] bytes = new byte[origSize];
            buf.get(bytes, buf.position(), origSize);
            payload.set(bytes, 0, origSize);
            buf = message.key();
            if (buf != null) {
                origSize = buf.remaining();
                bytes = new byte[origSize];
                buf.get(bytes, buf.position(), origSize);
                pKey.set(bytes, 0, origSize);
            }
            key.clear();
            key.set(this.kafkaRequest.getTopic(), this.kafkaRequest.getLeaderId(), this.kafkaRequest.getPartition(), this.currentOffset, msgAndOffset.offset() + 1L, message.checksum());
            key.setMessageSize(msgAndOffset.message().size());
            this.currentOffset = msgAndOffset.offset() + 1L;
            ++this.currentCount;
            return true;
        }
        return false;
    }

    public boolean fetch() throws IOException {
        if (this.currentOffset >= this.lastOffset) {
            return false;
        }
        long tempTime = System.currentTimeMillis();
        TopicAndPartition topicAndPartition = new TopicAndPartition(this.kafkaRequest.getTopic(), this.kafkaRequest.getPartition());
        log.debug((Object)("\nAsking for offset : " + this.currentOffset));
        PartitionFetchInfo partitionFetchInfo = new PartitionFetchInfo(this.currentOffset, this.fetchBufferSize);
        HashMap<TopicAndPartition, PartitionFetchInfo> fetchInfo = new HashMap<TopicAndPartition, PartitionFetchInfo>();
        fetchInfo.put(topicAndPartition, partitionFetchInfo);
        FetchRequest fetchRequest = new FetchRequest(1, "hive_kafka_client", 1000, 1024, fetchInfo);
        FetchResponse fetchResponse = null;
        try {
            fetchResponse = this.simpleConsumer.fetch(fetchRequest);
            if (fetchResponse.hasError()) {
                log.info((Object)"Error encountered during a fetch request from Kafka");
                log.info((Object)("Error Code generated : " + fetchResponse.errorCode(this.kafkaRequest.getTopic(), this.kafkaRequest.getPartition())));
                return false;
            }
            ByteBufferMessageSet messageBuffer = fetchResponse.messageSet(this.kafkaRequest.getTopic(), this.kafkaRequest.getPartition());
            this.lastFetchTime = System.currentTimeMillis() - tempTime;
            log.debug((Object)("Time taken to fetch : " + this.lastFetchTime / 1000L + " seconds"));
            log.debug((Object)("The size of the ByteBufferMessageSet returned is : " + messageBuffer.sizeInBytes()));
            int skipped = 0;
            this.totalFetchTime += this.lastFetchTime;
            this.messageIter = messageBuffer.iterator();
            Iterator messageIter2 = messageBuffer.iterator();
            MessageAndOffset message = null;
            while (messageIter2.hasNext()) {
                message = (MessageAndOffset)messageIter2.next();
                if (message.offset() < this.currentOffset) {
                    ++skipped;
                    continue;
                }
                log.debug((Object)("Skipped offsets till : " + message.offset()));
                break;
            }
            log.debug((Object)("Number of offsets to be skipped: " + skipped));
            while (skipped != 0) {
                MessageAndOffset skippedMessage = this.messageIter.next();
                log.debug((Object)("Skipping offset : " + skippedMessage.offset()));
                --skipped;
            }
            if (!this.messageIter.hasNext()) {
                System.out.println("No more data left to process. Returning false");
                this.messageIter = null;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            log.info((Object)"Exception generated during fetch");
            e.printStackTrace();
            return false;
        }
    }

    public void close() throws IOException {
        if (this.simpleConsumer != null) {
            this.simpleConsumer.close();
        }
    }

    public long getTotalBytes() {
        return this.lastOffset > this.beginOffset ? this.lastOffset - this.beginOffset : 0L;
    }

    public long getReadBytes() {
        return this.currentOffset - this.beginOffset;
    }

    public long getCount() {
        return this.currentCount;
    }

    public long getFetchTime() {
        return this.lastFetchTime;
    }

    public long getTotalFetchTime() {
        return this.totalFetchTime;
    }
}

