/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka.camus;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hive.kafka.camus.IKafkaKey;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class KafkaKey
implements WritableComparable<KafkaKey>,
IKafkaKey {
    public static final Text SERVER = new Text("server");
    public static final Text SERVICE = new Text("service");
    public static KafkaKey DUMMY_KEY = new KafkaKey();
    private String leaderId = "";
    private int partition = 0;
    private long beginOffset = 0L;
    private long offset = 0L;
    private long checksum = 0L;
    private String topic = "";
    private long time = 0L;
    private String server = "";
    private String service = "";
    private MapWritable partitionMap = new MapWritable();

    public KafkaKey() {
        this("dummy", "0", 0, 0L, 0L, 0L);
    }

    public KafkaKey(KafkaKey other) {
        this.partition = other.partition;
        this.beginOffset = other.beginOffset;
        this.offset = other.offset;
        this.checksum = other.checksum;
        this.topic = other.topic;
        this.time = other.time;
        this.server = other.server;
        this.service = other.service;
        this.partitionMap = new MapWritable(other.partitionMap);
    }

    public KafkaKey(String topic, String leaderId, int partition) {
        this.set(topic, leaderId, partition, 0L, 0L, 0L);
    }

    public KafkaKey(String topic, String leaderId, int partition, long beginOffset, long offset) {
        this.set(topic, leaderId, partition, beginOffset, offset, 0L);
    }

    public KafkaKey(String topic, String leaderId, int partition, long beginOffset, long offset, long checksum) {
        this.set(topic, leaderId, partition, beginOffset, offset, checksum);
    }

    public void set(String topic, String leaderId, int partition, long beginOffset, long offset, long checksum) {
        this.leaderId = leaderId;
        this.partition = partition;
        this.beginOffset = beginOffset;
        this.offset = offset;
        this.checksum = checksum;
        this.topic = topic;
        this.time = System.currentTimeMillis();
    }

    public void clear() {
        this.leaderId = "";
        this.partition = 0;
        this.beginOffset = 0L;
        this.offset = 0L;
        this.checksum = 0L;
        this.topic = "";
        this.time = 0L;
        this.server = "";
        this.service = "";
        this.partitionMap = new MapWritable();
    }

    @Override
    public String getServer() {
        return this.partitionMap.get((Object)SERVER).toString();
    }

    public void setServer(String newServer) {
        this.partitionMap.put((Writable)SERVER, (Writable)new Text(newServer));
    }

    @Override
    public String getService() {
        return this.partitionMap.get((Object)SERVICE).toString();
    }

    public void setService(String newService) {
        this.partitionMap.put((Writable)SERVICE, (Writable)new Text(newService));
    }

    @Override
    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    public String getLeaderId() {
        return this.leaderId;
    }

    @Override
    public int getPartition() {
        return this.partition;
    }

    @Override
    public long getBeginOffset() {
        return this.beginOffset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public long getChecksum() {
        return this.checksum;
    }

    @Override
    public long getMessageSize() {
        Text key = new Text("message.size");
        if (this.partitionMap.containsKey((Object)key)) {
            return ((LongWritable)this.partitionMap.get((Object)key)).get();
        }
        return 1024L;
    }

    public void setMessageSize(long messageSize) {
        Text key = new Text("message.size");
        this.put((Writable)key, (Writable)new LongWritable(messageSize));
    }

    @Override
    public void put(Writable key, Writable value) {
        this.partitionMap.put(key, value);
    }

    public void addAllPartitionMap(MapWritable partitionMap) {
        this.partitionMap.putAll((Map)partitionMap);
    }

    @Override
    public MapWritable getPartitionMap() {
        return this.partitionMap;
    }

    public void readFields(DataInput in) throws IOException {
        this.leaderId = UTF8.readString((DataInput)in);
        this.partition = in.readInt();
        this.beginOffset = in.readLong();
        this.offset = in.readLong();
        this.checksum = in.readLong();
        this.topic = in.readUTF();
        this.time = in.readLong();
        this.server = in.readUTF();
        this.service = in.readUTF();
        this.partitionMap = new MapWritable();
        try {
            this.partitionMap.readFields(in);
        }
        catch (IOException e) {
            this.setServer(this.server);
            this.setService(this.service);
        }
    }

    public void write(DataOutput out) throws IOException {
        UTF8.writeString((DataOutput)out, (String)this.leaderId);
        out.writeInt(this.partition);
        out.writeLong(this.beginOffset);
        out.writeLong(this.offset);
        out.writeLong(this.checksum);
        out.writeUTF(this.topic);
        out.writeLong(this.time);
        out.writeUTF(this.server);
        out.writeUTF(this.service);
        this.partitionMap.write(out);
    }

    public int compareTo(KafkaKey o) {
        if (this.partition != o.partition) {
            this.partition = o.partition;
            return this.partition;
        }
        if (this.offset > o.offset) {
            return 1;
        }
        if (this.offset < o.offset) {
            return -1;
        }
        if (this.checksum > o.checksum) {
            return 1;
        }
        if (this.checksum < o.checksum) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("topic=");
        builder.append(this.topic);
        builder.append(" partition=");
        builder.append(this.partition);
        builder.append("leaderId=");
        builder.append(this.leaderId);
        builder.append(" server=");
        builder.append(this.server);
        builder.append(" service=");
        builder.append(this.service);
        builder.append(" beginOffset=");
        builder.append(this.beginOffset);
        builder.append(" offset=");
        builder.append(this.offset);
        builder.append(" msgSize=");
        builder.append(this.getMessageSize());
        builder.append(" server=");
        builder.append(this.server);
        builder.append(" checksum=");
        builder.append(this.checksum);
        builder.append(" time=");
        builder.append(this.time);
        for (Map.Entry e : this.partitionMap.entrySet()) {
            builder.append(" " + e.getKey() + "=");
            builder.append(((Writable)e.getValue()).toString());
        }
        return builder.toString();
    }
}

