/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka.camus;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.kafka.AvroSchemaGenerator;
import org.apache.hadoop.hive.kafka.camus.CachedSchemaRegistry;
import org.apache.hadoop.hive.kafka.camus.CamusWrapper;
import org.apache.hadoop.hive.kafka.camus.MessageDecoder;
import org.apache.hadoop.hive.kafka.camus.MessageDecoderException;
import org.apache.hadoop.hive.kafka.camus.SchemaRegistry;
import org.apache.hadoop.hive.serde2.avro.AvroGenericRecordWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;

public class KafkaAvroMessageDecoder
extends MessageDecoder<byte[], GenericData.Record> {
    protected DecoderFactory decoderFactory;
    protected SchemaRegistry<Schema> registry;
    private Schema latestSchema;
    private static Logger log = null;

    @Override
    public void init(Properties props, String topicName) {
        super.init(props, topicName);
        if (log == null) {
            log = Logger.getLogger(this.getClass());
        }
        try {
            Schema schema;
            SchemaRegistry registry = (SchemaRegistry)Class.forName("org.apache.hadoop.hive.kafka.camus.MemorySchemaRegistry").newInstance();
            registry.init(props);
            this.registry = new CachedSchemaRegistry<Schema>(registry);
            Schema.Parser parser = new Schema.Parser();
            String schemaFile = props.getProperty("kafka.avro.schema.file", null);
            if (schemaFile != null && !schemaFile.isEmpty()) {
                Path pt = new Path(schemaFile);
                FileSystem fs = FileSystem.get((Configuration)new Configuration());
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(pt)));
                StringBuilder line = new StringBuilder();
                String tempLine = br.readLine();
                while (tempLine != null) {
                    line.append(tempLine);
                    tempLine = br.readLine();
                }
                log.info((Object)("Setting expected schema, from file, to " + line.toString()));
                try {
                    schema = parser.parse(line.toString());
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to parse Avro schema from " + schemaFile, e);
                }
            } else {
                AvroSchemaGenerator avroSchemaGenerator = new AvroSchemaGenerator();
                schema = avroSchemaGenerator.getSchema(props.getProperty("columns"), props.getProperty("columns.types"), props.getProperty("columns.comments"), "avro.schema.namespace", "avro.schema.name", "avro.schema.doc");
                log.info((Object)("Setting expected schema, from hive table schema, to " + schema));
            }
            this.latestSchema = schema;
        }
        catch (Exception e) {
            throw new MessageDecoderException(e);
        }
        this.decoderFactory = DecoderFactory.get();
    }

    @Override
    public AvroGenericRecordWritable decode(byte[] payload) {
        try {
            MessageDecoderHelper helper = new MessageDecoderHelper(this.registry, this.topicName, payload).invoke();
            GenericDatumReader reader = new GenericDatumReader(helper.getTargetSchema());
            log.debug((Object)"Trying to read kafka payload");
            log.debug((Object)("buffer: " + helper.getBuffer()));
            log.debug((Object)("start: " + helper.getStart()));
            log.debug((Object)("length: " + helper.getLength()));
            log.debug((Object)("target schema: " + helper.getTargetSchema()));
            log.debug((Object)("schema: " + helper.getSchema()));
            GenericRecord record = (GenericRecord)reader.read(null, (Decoder)this.decoderFactory.binaryDecoder(helper.getBuffer().array(), helper.getStart(), helper.getLength(), null));
            log.debug((Object)("Read kafka payload as " + record));
            AvroGenericRecordWritable grw = new AvroGenericRecordWritable(record);
            grw.setFileSchema(this.latestSchema);
            return grw;
        }
        catch (IOException e) {
            throw new MessageDecoderException(e);
        }
    }

    public static class CamusAvroWrapper
    extends CamusWrapper<GenericData.Record> {
        public CamusAvroWrapper(GenericData.Record record) {
            super(record);
            GenericData.Record header = (GenericData.Record)((GenericData.Record)super.getRecord()).get("header");
            if (header != null) {
                if (header.get("server") != null) {
                    this.put((Writable)new Text("server"), (Writable)new Text(header.get("server").toString()));
                }
                if (header.get("service") != null) {
                    this.put((Writable)new Text("service"), (Writable)new Text(header.get("service").toString()));
                }
            }
        }

        @Override
        public long getTimestamp() {
            GenericData.Record header = (GenericData.Record)((GenericData.Record)super.getRecord()).get("header");
            if (header != null && header.get("time") != null) {
                return (Long)header.get("time");
            }
            if (((GenericData.Record)super.getRecord()).get("timestamp") != null) {
                return (Long)((GenericData.Record)super.getRecord()).get("timestamp");
            }
            return System.currentTimeMillis();
        }
    }

    private class MessageDecoderHelper {
        private ByteBuffer buffer;
        private Schema schema;
        private int start;
        private int length;
        private Schema targetSchema;
        private static final byte MAGIC_BYTE = 0;
        private final SchemaRegistry<Schema> registry;
        private final String topicName;
        private byte[] payload;

        public MessageDecoderHelper(SchemaRegistry<Schema> registry, String topicName, byte[] payload) {
            this.registry = registry;
            this.topicName = topicName;
            this.payload = payload;
        }

        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public int getStart() {
            return this.start;
        }

        public int getLength() {
            return this.length;
        }

        public Schema getTargetSchema() {
            return new Schema.Parser().parse(this.targetSchema.toString());
        }

        private ByteBuffer getByteBuffer(byte[] payload) {
            ByteBuffer buffer = ByteBuffer.wrap(payload);
            return buffer;
        }

        public MessageDecoderHelper invoke() {
            this.buffer = this.getByteBuffer(this.payload);
            this.start = this.buffer.position() + this.buffer.arrayOffset();
            this.length = this.buffer.limit();
            this.targetSchema = KafkaAvroMessageDecoder.this.latestSchema;
            return this;
        }
    }
}

