/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka.camus;

import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class CamusWrapper<R> {
    private R record;
    private long timestamp;
    private MapWritable partitionMap;

    public CamusWrapper(R record) {
        this(record, System.currentTimeMillis());
    }

    public CamusWrapper(R record, long timestamp) {
        this(record, timestamp, "unknown_server", "unknown_service");
    }

    public CamusWrapper(R record, long timestamp, String server, String service) {
        this.record = record;
        this.timestamp = timestamp;
        this.partitionMap = new MapWritable();
        this.partitionMap.put((Writable)new Text("server"), (Writable)new Text(server));
        this.partitionMap.put((Writable)new Text("service"), (Writable)new Text(service));
    }

    public R getRecord() {
        return this.record;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void put(Writable key, Writable value) {
        this.partitionMap.put(key, value);
    }

    public Writable get(Writable key) {
        return this.partitionMap.get((Object)key);
    }

    public MapWritable getPartitionMap() {
        return this.partitionMap;
    }
}

