/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka.camus;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hive.kafka.camus.SchemaDetails;
import org.apache.hadoop.hive.kafka.camus.SchemaRegistry;

public class CachedSchemaRegistry<S>
implements SchemaRegistry<S> {
    private final SchemaRegistry<S> registry;
    private final ConcurrentHashMap<CachedSchemaTuple, S> cachedById;
    private final ConcurrentHashMap<String, S> cachedLatest;

    @Override
    public void init(Properties props) {
    }

    public CachedSchemaRegistry(SchemaRegistry<S> registry) {
        this.registry = registry;
        this.cachedById = new ConcurrentHashMap();
        this.cachedLatest = new ConcurrentHashMap();
    }

    @Override
    public String register(String topic, S schema) {
        return this.registry.register(topic, schema);
    }

    @Override
    public S getSchemaByID(String topic, String id) {
        CachedSchemaTuple cacheKey = new CachedSchemaTuple(topic, id);
        S schema = this.cachedById.get(cacheKey);
        if (schema == null) {
            schema = this.registry.getSchemaByID(topic, id);
            this.cachedById.putIfAbsent(cacheKey, schema);
        }
        return schema;
    }

    @Override
    public SchemaDetails<S> getLatestSchemaByTopic(String topicName) {
        S schema = this.cachedLatest.get(topicName);
        if (schema == null) {
            schema = this.registry.getLatestSchemaByTopic(topicName).getSchema();
            this.cachedLatest.putIfAbsent(topicName, schema);
        }
        return this.registry.getLatestSchemaByTopic(topicName);
    }

    public static class CachedSchemaTuple {
        private final String topic;
        private final String id;

        public CachedSchemaTuple(String topic, String id) {
            this.topic = topic;
            this.id = id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.topic == null ? 0 : this.topic.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CachedSchemaTuple other = (CachedSchemaTuple)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
        }

        public String toString() {
            return "CachedSchemaTuple [topic=" + this.topic + ", id=" + this.id + "]";
        }
    }
}

