/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.kafka.Props;
import org.apache.hadoop.hive.kafka.UndefinedPropertyException;
import org.apache.hadoop.io.BytesWritable;

public class KafkaUtils {
    public static PathFilter PATH_FILTER = new PathFilter(){

        public boolean accept(Path path) {
            return !path.getName().startsWith("_") && !path.getName().startsWith(".");
        }
    };

    public static Path getLastPath(Path path, FileSystem fs) throws IOException {
        Object[] statuses = fs.listStatus(path, PATH_FILTER);
        if (statuses.length == 0) {
            return path;
        }
        Arrays.sort(statuses);
        return statuses[statuses.length - 1].getPath();
    }

    public static String getFileName(Path path) throws IOException {
        String fullname = path.toUri().toString();
        String[] parts = fullname.split("/");
        if (parts.length < 1) {
            throw new IOException("Invalid path " + fullname);
        }
        return parts[parts.length - 1];
    }

    public static List<String> readText(FileSystem fs, String inputFile) throws IOException, FileNotFoundException {
        Path path = new Path(inputFile);
        return KafkaUtils.readText(fs, path);
    }

    public static List<String> readText(FileSystem fs, Path path) throws IOException, FileNotFoundException {
        if (!fs.exists(path)) {
            throw new FileNotFoundException("File " + path + " doesn't exist!");
        }
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fs.open(path)));
        ArrayList<String> buf = new ArrayList<String>();
        String line = null;
        while ((line = in.readLine()) != null) {
            if (line.trim().length() <= 0) continue;
            buf.add(new String(line.trim()));
        }
        in.close();
        return buf;
    }

    public static void writeText(FileSystem fs, Path outPath, String content) throws IOException {
        long timestamp = System.currentTimeMillis();
        String localFile = "/tmp/Kafka_tmp_" + timestamp;
        PrintWriter writer = new PrintWriter(new FileWriter(localFile));
        writer.println(content);
        writer.close();
        Path src = new Path(localFile);
        fs.moveFromLocalFile(src, outPath);
    }

    public static Props getPropsFromJob(Configuration conf) {
        String propsString = conf.get("kafka.etl.props");
        if (propsString == null) {
            throw new UndefinedPropertyException("The required property kafka.etl.props was not found in the Configuration.");
        }
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(propsString.getBytes("UTF-8"));
            Properties properties = new Properties();
            properties.load(input);
            return new Props(new Properties[]{properties});
        }
        catch (IOException e) {
            throw new RuntimeException("This is not possible!", e);
        }
    }

    public static void setPropsInJob(Configuration conf, Props props) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            props.store(output);
            conf.set("kafka.etl.props", new String(output.toByteArray(), "UTF-8"));
        }
        catch (IOException e) {
            throw new RuntimeException("This is not possible!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Props readProps(String file) throws IOException {
        Path path = new Path(file);
        FileSystem fs = path.getFileSystem(new Configuration());
        if (fs.exists(path)) {
            FSDataInputStream input = fs.open(path);
            try {
                Props p = new Props(new InputStream[]{input});
                Props props = new Props(p);
                return props;
            }
            finally {
                input.close();
            }
        }
        return new Props();
    }

    public static String findContainingJar(Class my_class, ClassLoader loader) {
        String class_file = my_class.getName().replaceAll("\\.", "/") + ".class";
        return KafkaUtils.findContainingJar(class_file, loader);
    }

    public static String findContainingJar(String fileName, ClassLoader loader) {
        try {
            Enumeration<URL> itr = loader.getResources(fileName);
            while (itr.hasMoreElements()) {
                URL url = itr.nextElement();
                if (!"jar".equals(url.getProtocol())) continue;
                String toReturn = url.getPath();
                if (toReturn.startsWith("file:")) {
                    toReturn = toReturn.substring("file:".length());
                }
                toReturn = URLDecoder.decode(toReturn, "UTF-8");
                return toReturn.replaceAll("!.*$", "");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static byte[] getBytes(BytesWritable val) {
        byte[] buffer = val.getBytes();
        long len = val.getLength();
        byte[] bytes = buffer;
        if (len < (long)buffer.length) {
            bytes = new byte[(int)len];
            System.arraycopy(buffer, 0, bytes, 0, (int)len);
        }
        return bytes;
    }
}

