/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka;

import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.kafka.KafkaBackedTableProperties;
import org.apache.hadoop.hive.kafka.KafkaInputFormat;
import org.apache.hadoop.hive.kafka.KafkaOutputFormat;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.avro.AvroSerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.log4j.Logger;

public class KafkaStorageHandler
implements HiveStorageHandler {
    private static final Logger LOG = Logger.getLogger((String)KafkaStorageHandler.class.getName());
    private Configuration conf;

    public void setConf(Configuration entries) {
        this.conf = entries;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public Class<? extends InputFormat> getInputFormatClass() {
        return KafkaInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return KafkaOutputFormat.class;
    }

    public Class<? extends SerDe> getSerDeClass() {
        return AvroSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return null;
    }

    public HiveAuthorizationProvider getAuthorizationProvider() throws HiveException {
        return null;
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        Properties tableProperties = tableDesc.getProperties();
        new KafkaBackedTableProperties().initialize(tableProperties, jobProperties, tableDesc);
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        Properties tableProperties = tableDesc.getProperties();
        new KafkaBackedTableProperties().initialize(tableProperties, jobProperties, tableDesc);
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> stringStringMap) {
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
    }
}

