/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka;

import java.io.IOException;
import java.util.HashSet;
import kafka.message.Message;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.hive.kafka.camus.KafkaKey;
import org.apache.hadoop.hive.kafka.camus.KafkaReader;
import org.apache.hadoop.hive.kafka.camus.KafkaRequest;
import org.apache.hadoop.hive.kafka.camus.KafkaSplit;
import org.apache.hadoop.hive.kafka.camus.MessageDecoder;
import org.apache.hadoop.hive.kafka.camus.MessageDecoderFactory;
import org.apache.hadoop.hive.serde2.avro.AvroGenericRecordWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.log4j.Logger;

public class KafkaRecordReader
implements RecordReader<KafkaKey, AvroGenericRecordWritable> {
    private static final String PRINT_MAX_DECODER_EXCEPTIONS = "max.decoder.exceptions.to.print";
    private static final String DEFAULT_SERVER = "server";
    private static final String DEFAULT_SERVICE = "service";
    private KafkaReader reader;
    private long totalBytes;
    private long readBytes = 0L;
    private boolean skipSchemaErrors = false;
    private MessageDecoder decoder;
    private final BytesWritable msgValue = new BytesWritable();
    private final BytesWritable msgKey = new BytesWritable();
    private final KafkaKey key = new KafkaKey();
    private AvroGenericRecordWritable value;
    private int maxPullHours = 0;
    private int exceptionCount = 0;
    private long maxPullTime = 0L;
    private long beginTimeStamp = 0L;
    private long endTimeStamp = 0L;
    private HashSet<String> ignoreServerServiceList = null;
    private String statusMsg = "";
    KafkaSplit split;
    JobConf conf;
    Reporter reporter;
    private static Logger log = Logger.getLogger(KafkaRecordReader.class);

    public KafkaRecordReader(InputSplit split, JobConf conf, Reporter reporter) throws IOException {
        this.initialize(split, conf, reporter);
    }

    public void initialize(InputSplit split, JobConf conf, Reporter reporter) throws IOException {
        log.info((Object)("classpath: " + System.getProperty("java.class.path")));
        ClassLoader loader = KafkaRecordReader.class.getClassLoader();
        log.info((Object)("PWD: " + System.getProperty("user.dir")));
        log.info((Object)("classloader: " + loader.getClass()));
        log.info((Object)("org.apache.avro.Schema: " + loader.getResource("org/apache/avro/Schema.class")));
        this.split = (KafkaSplit)split;
        this.conf = conf;
        this.reporter = reporter;
        this.skipSchemaErrors = false;
        this.endTimeStamp = Long.MAX_VALUE;
        this.maxPullTime = Long.MAX_VALUE;
        this.beginTimeStamp = 0L;
        this.ignoreServerServiceList = new HashSet();
        this.totalBytes = this.split.getLength();
    }

    public synchronized void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    private AvroGenericRecordWritable getWrappedRecord(String topicName, byte[] payload) throws IOException {
        AvroGenericRecordWritable r;
        block2: {
            r = null;
            try {
                r = this.decoder.decode(payload);
            }
            catch (Exception e) {
                if (this.skipSchemaErrors) break block2;
                throw new IOException(e);
            }
        }
        return r;
    }

    private static byte[] getBytes(BytesWritable val) {
        byte[] buffer = val.getBytes();
        long len = val.getLength();
        byte[] bytes = buffer;
        if (len < (long)buffer.length) {
            bytes = new byte[(int)len];
            System.arraycopy(buffer, 0, bytes, 0, (int)len);
        }
        return bytes;
    }

    public float getProgress() throws IOException {
        if (this.getPos() == 0L) {
            return 0.0f;
        }
        if (this.getPos() >= this.totalBytes) {
            return 1.0f;
        }
        return (float)((double)this.getPos() / (double)this.totalBytes);
    }

    public long getPos() throws IOException {
        return this.readBytes;
    }

    public KafkaKey createKey() {
        return this.key;
    }

    public AvroGenericRecordWritable createValue() {
        return new AvroGenericRecordWritable();
    }

    public boolean next(KafkaKey key, AvroGenericRecordWritable value) throws IOException {
        Object message = null;
        while (true) {
            try {
                while (true) {
                    if (this.reader == null || !this.reader.hasNext()) {
                        KafkaRequest request = (KafkaRequest)this.split.popRequest();
                        if (request == null) {
                            return false;
                        }
                        if (this.maxPullHours > 0) {
                            this.endTimeStamp = 0L;
                        }
                        key.set(request.getTopic(), request.getLeaderId(), request.getPartition(), request.getOffset(), request.getOffset(), 0L);
                        log.info((Object)("\n\ntopic:" + request.getTopic() + " partition:" + request.getPartition() + " beginOffset:" + request.getOffset() + " estimatedLastOffset:" + request.getLastOffset()));
                        this.statusMsg = this.statusMsg + (this.statusMsg.length() > 0 ? "; " : "");
                        this.statusMsg = this.statusMsg + request.getTopic() + ":" + request.getLeaderId() + ":" + request.getPartition();
                        this.reporter.setStatus(this.statusMsg);
                        if (this.reader != null) {
                            this.closeReader();
                        }
                        this.reader = new KafkaReader(this.conf, request, 30000, 0x100000);
                        this.decoder = MessageDecoderFactory.createMessageDecoder(this.conf, request.getTopic());
                    }
                    int count = 0;
                    while (this.reader.getNext(key, this.msgValue, this.msgKey)) {
                        AvroGenericRecordWritable wrapper;
                        this.readBytes += key.getMessageSize();
                        ++count;
                        byte[] bytes = KafkaRecordReader.getBytes(this.msgValue);
                        byte[] keyBytes = KafkaRecordReader.getBytes(this.msgKey);
                        Message messageWithKey = new Message(bytes, keyBytes);
                        Message messageWithoutKey = new Message(bytes);
                        long checksum = key.getChecksum();
                        if (checksum != messageWithKey.checksum() && checksum != messageWithoutKey.checksum()) {
                            throw new ChecksumException("Invalid message checksum : MessageWithKey : " + messageWithKey.checksum() + " MessageWithoutKey checksum : " + messageWithoutKey.checksum() + ". Expected " + key.getChecksum(), key.getOffset());
                        }
                        long tempTime = System.currentTimeMillis();
                        try {
                            wrapper = this.getWrappedRecord(key.getTopic(), bytes);
                        }
                        catch (Exception e) {
                            log.warn((Object)"bad record!", (Throwable)e);
                            throw new Exception(e);
                        }
                        if (wrapper == null) {
                            log.warn((Object)"bad record");
                            continue;
                        }
                        long secondTime = System.currentTimeMillis();
                        value.setFileSchema(wrapper.getFileSchema());
                        value.setRecord(wrapper.getRecord());
                        long decodeTime = secondTime - tempTime;
                        if (this.reader != null) {
                            // empty if block
                        }
                        return true;
                    }
                    log.info((Object)("Records read : " + count));
                    count = 0;
                    this.reader = null;
                }
            }
            catch (Throwable t) {
                Exception e = new Exception(t.getLocalizedMessage(), t);
                e.setStackTrace(t.getStackTrace());
                log.error((Object)"wtf", (Throwable)e);
                this.reader = null;
                continue;
            }
            break;
        }
    }

    private void closeReader() throws IOException {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.reader = null;
            }
        }
    }

    public void setServerService() {
        if (this.ignoreServerServiceList.contains(this.key.getTopic()) || this.ignoreServerServiceList.contains("all")) {
            this.key.setServer(DEFAULT_SERVER);
            this.key.setService(DEFAULT_SERVICE);
        }
    }

    public static int getMaximumDecoderExceptionsToPrint(JobContext job) {
        return job.getConfiguration().getInt(PRINT_MAX_DECODER_EXCEPTIONS, 10);
    }
}

