/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka;

import java.io.IOException;
import java.net.URI;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.common.ErrorMapping;
import kafka.common.TopicAndPartition;
import kafka.javaapi.OffsetRequest;
import kafka.javaapi.OffsetResponse;
import kafka.javaapi.PartitionMetadata;
import kafka.javaapi.TopicMetadata;
import kafka.javaapi.TopicMetadataRequest;
import kafka.javaapi.consumer.SimpleConsumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.kafka.KafkaRecordReader;
import org.apache.hadoop.hive.kafka.camus.BaseAllocator;
import org.apache.hadoop.hive.kafka.camus.CamusRequest;
import org.apache.hadoop.hive.kafka.camus.KafkaAvroMessageDecoder;
import org.apache.hadoop.hive.kafka.camus.KafkaKey;
import org.apache.hadoop.hive.kafka.camus.KafkaRequest;
import org.apache.hadoop.hive.kafka.camus.LeaderInfo;
import org.apache.hadoop.hive.kafka.camus.MessageDecoder;
import org.apache.hadoop.hive.kafka.camus.MessageDecoderFactory;
import org.apache.hadoop.hive.kafka.camus.WorkAllocator;
import org.apache.hadoop.hive.serde2.avro.AvroGenericRecordWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.log4j.Logger;

public class KafkaInputFormat
implements InputFormat<KafkaKey, AvroGenericRecordWritable> {
    public static final String KAFKA_BLACKLIST_TOPIC = "kafka.blacklist.topics";
    public static final String KAFKA_WHITELIST_TOPIC = "kafka.whitelist.topics";
    public static final String KAFKA_MOVE_TO_LAST_OFFSET_LIST = "kafka.move.to.last.offset.list";
    public static final String KAFKA_CLIENT_BUFFER_SIZE = "kafka.client.buffer.size";
    public static final String KAFKA_CLIENT_SO_TIMEOUT = "kafka.client.so.timeout";
    public static final String KAFKA_MAX_PULL_HRS = "kafka.max.pull.hrs";
    public static final String KAFKA_MAX_PULL_MINUTES_PER_TASK = "kafka.max.pull.minutes.per.task";
    public static final String KAFKA_MAX_HISTORICAL_DAYS = "kafka.max.historical.days";
    public static final String CAMUS_MESSAGE_DECODER_CLASS = "camus.message.decoder.class";
    public static final String ETL_IGNORE_SCHEMA_ERRORS = "etl.ignore.schema.errors";
    public static final String ETL_AUDIT_IGNORE_SERVICE_TOPIC_LIST = "etl.audit.ignore.service.topic.list";
    public static final String CAMUS_WORK_ALLOCATOR_CLASS = "camus.work.allocator.class";
    public static final String CAMUS_WORK_ALLOCATOR_DEFAULT = "com.linkedin.camus.workallocater.BaseAllocator";
    private static Logger log = null;

    public KafkaInputFormat() {
        if (log == null) {
            log = Logger.getLogger(this.getClass());
        }
    }

    public static void setLogger(Logger log) {
        KafkaInputFormat.log = log;
    }

    public RecordReader<KafkaKey, AvroGenericRecordWritable> getRecordReader(InputSplit split, JobConf conf, Reporter reporter) throws IOException {
        return new KafkaRecordReader(split, conf, reporter);
    }

    public static String getKafkaBrokers(JobConf job) {
        return job.get("kafka.service.uri");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TopicMetadata> getKafkaMetadata(JobConf conf) {
        ArrayList metaRequestTopics = new ArrayList();
        String brokerString = KafkaInputFormat.getKafkaBrokers(conf);
        if (brokerString.isEmpty()) {
            throw new InvalidParameterException("kafka.brokers must contain at least one node");
        }
        List<String> brokers = Arrays.asList(brokerString.split("\\s*,\\s*"));
        Collections.shuffle(brokers);
        boolean fetchMetaDataSucceeded = false;
        int i = 0;
        List topicMetadataList = null;
        Exception savedException = null;
        while (i < brokers.size() && !fetchMetaDataSucceeded) {
            log.info((Object)("Trying to connect to broker: " + brokers.get(i)));
            SimpleConsumer consumer = this.createConsumer(conf, brokers.get(i));
            log.info((Object)String.format("Fetching metadata from broker %s with client id %s for %d topic(s) %s", brokers.get(i), consumer.clientId(), metaRequestTopics.size(), metaRequestTopics));
            try {
                topicMetadataList = consumer.send(new TopicMetadataRequest(metaRequestTopics)).topicsMetadata();
                fetchMetaDataSucceeded = true;
            }
            catch (Exception e) {
                savedException = e;
                log.warn((Object)String.format("Fetching topic metadata with client id %s for topics [%s] from broker [%s] failed", consumer.clientId(), metaRequestTopics, brokers.get(i)), (Throwable)e);
            }
            finally {
                consumer.close();
                ++i;
            }
        }
        if (!fetchMetaDataSucceeded) {
            throw new RuntimeException("Failed to obtain metadata!", savedException);
        }
        return topicMetadataList;
    }

    private SimpleConsumer createConsumer(JobConf conf, String broker) {
        if (!broker.matches(".+:\\d+")) {
            throw new InvalidParameterException("The kakfa broker " + broker + " must follow address:port pattern");
        }
        String[] hostPort = broker.split(":");
        SimpleConsumer consumer = new SimpleConsumer(hostPort[0], Integer.valueOf(hostPort[1]).intValue(), 30000, 0x100000, "hive_kafka_client");
        return consumer;
    }

    public ArrayList<CamusRequest> fetchLatestOffsetAndCreateKafkaRequests(JobConf conf, HashMap<LeaderInfo, ArrayList<TopicAndPartition>> offsetRequestInfo) {
        ArrayList<CamusRequest> finalRequests = new ArrayList<CamusRequest>();
        for (LeaderInfo leader : offsetRequestInfo.keySet()) {
            SimpleConsumer consumer = new SimpleConsumer(leader.getUri().getHost(), leader.getUri().getPort(), 30000, 0x100000, "hive_kafka_client");
            PartitionOffsetRequestInfo partitionLatestOffsetRequestInfo = new PartitionOffsetRequestInfo(kafka.api.OffsetRequest.LatestTime(), 1);
            PartitionOffsetRequestInfo partitionEarliestOffsetRequestInfo = new PartitionOffsetRequestInfo(kafka.api.OffsetRequest.EarliestTime(), 1);
            HashMap<TopicAndPartition, PartitionOffsetRequestInfo> latestOffsetInfo = new HashMap<TopicAndPartition, PartitionOffsetRequestInfo>();
            HashMap<TopicAndPartition, PartitionOffsetRequestInfo> earliestOffsetInfo = new HashMap<TopicAndPartition, PartitionOffsetRequestInfo>();
            ArrayList<TopicAndPartition> topicAndPartitions = offsetRequestInfo.get(leader);
            for (TopicAndPartition topicAndPartition : topicAndPartitions) {
                latestOffsetInfo.put(topicAndPartition, partitionLatestOffsetRequestInfo);
                earliestOffsetInfo.put(topicAndPartition, partitionEarliestOffsetRequestInfo);
            }
            OffsetResponse latestOffsetResponse = consumer.getOffsetsBefore(new OffsetRequest(latestOffsetInfo, kafka.api.OffsetRequest.CurrentVersion(), "hive_kafka_client"));
            OffsetResponse earliestOffsetResponse = consumer.getOffsetsBefore(new OffsetRequest(earliestOffsetInfo, kafka.api.OffsetRequest.CurrentVersion(), "hive_kafka_client"));
            consumer.close();
            for (TopicAndPartition topicAndPartition : topicAndPartitions) {
                long latestOffset = latestOffsetResponse.offsets(topicAndPartition.topic(), topicAndPartition.partition())[0];
                long earliestOffset = earliestOffsetResponse.offsets(topicAndPartition.topic(), topicAndPartition.partition())[0];
                KafkaRequest etlRequest = new KafkaRequest(conf, topicAndPartition.topic(), Integer.toString(leader.getLeaderId()), topicAndPartition.partition(), leader.getUri());
                etlRequest.setLatestOffset(latestOffset);
                etlRequest.setEarliestOffset(earliestOffset);
                finalRequests.add(etlRequest);
            }
        }
        return finalRequests;
    }

    public String createTopicRegEx(HashSet<String> topicsSet) {
        String regex = "";
        StringBuilder stringbuilder = new StringBuilder();
        for (String whiteList : topicsSet) {
            stringbuilder.append(whiteList);
            stringbuilder.append("|");
        }
        regex = "(" + stringbuilder.substring(0, stringbuilder.length() - 1) + ")";
        Pattern.compile(regex);
        return regex;
    }

    public List<TopicMetadata> filterWhitelistTopics(List<TopicMetadata> topicMetadataList, HashSet<String> whiteListTopics) {
        ArrayList<TopicMetadata> filteredTopics = new ArrayList<TopicMetadata>();
        String regex = this.createTopicRegEx(whiteListTopics);
        for (TopicMetadata topicMetadata : topicMetadataList) {
            if (Pattern.matches(regex, topicMetadata.topic())) {
                filteredTopics.add(topicMetadata);
                continue;
            }
            log.info((Object)("Discarding topic : " + topicMetadata.topic()));
        }
        return filteredTopics;
    }

    public InputSplit[] getSplits(JobConf conf, int numSplits) throws IOException {
        HashMap<LeaderInfo, ArrayList<TopicAndPartition>> offsetRequestInfo = new HashMap<LeaderInfo, ArrayList<TopicAndPartition>>();
        try {
            List<TopicMetadata> topicMetadataList = this.getKafkaMetadata(conf);
            HashSet<String> whiteListTopics = new HashSet<String>(Arrays.asList(KafkaInputFormat.getKafkaWhitelistTopic(conf)));
            if (!whiteListTopics.isEmpty()) {
                topicMetadataList = this.filterWhitelistTopics(topicMetadataList, whiteListTopics);
            }
            HashSet<String> blackListTopics = new HashSet<String>(Arrays.asList(KafkaInputFormat.getKafkaBlacklistTopic(conf)));
            String regex = "";
            if (!blackListTopics.isEmpty()) {
                regex = this.createTopicRegEx(blackListTopics);
            }
            for (TopicMetadata topicMetadata : topicMetadataList) {
                if (Pattern.matches(regex, topicMetadata.topic())) {
                    log.info((Object)("Discarding topic (blacklisted): " + topicMetadata.topic()));
                    continue;
                }
                if (!this.createMessageDecoder(conf, topicMetadata.topic())) {
                    log.info((Object)("Discarding topic (Decoder generation failed) : " + topicMetadata.topic()));
                    continue;
                }
                if (topicMetadata.errorCode() != ErrorMapping.NoError()) {
                    log.info((Object)("Skipping the creation of ETL request for Whole Topic : " + topicMetadata.topic() + " Exception : " + ErrorMapping.exceptionFor((short)topicMetadata.errorCode())));
                    continue;
                }
                for (PartitionMetadata partitionMetadata : topicMetadata.partitionsMetadata()) {
                    ArrayList<Object> topicAndPartitions;
                    LeaderInfo leader;
                    if (partitionMetadata.errorCode() == ErrorMapping.LeaderNotAvailableCode()) {
                        log.info((Object)("Skipping the creation of ETL request for Topic : " + topicMetadata.topic() + " and Partition : " + partitionMetadata.partitionId() + " Exception : " + ErrorMapping.exceptionFor((short)partitionMetadata.errorCode())));
                        continue;
                    }
                    if (partitionMetadata.errorCode() != ErrorMapping.NoError()) {
                        log.warn((Object)("Receiving non-fatal error code, Continuing the creation of ETL request for Topic : " + topicMetadata.topic() + " and Partition : " + partitionMetadata.partitionId() + " Exception : " + ErrorMapping.exceptionFor((short)partitionMetadata.errorCode())));
                    }
                    if (offsetRequestInfo.containsKey(leader = new LeaderInfo(new URI("tcp://" + partitionMetadata.leader().getConnectionString()), partitionMetadata.leader().id()))) {
                        topicAndPartitions = offsetRequestInfo.get(leader);
                        topicAndPartitions.add(new TopicAndPartition(topicMetadata.topic(), partitionMetadata.partitionId()));
                        offsetRequestInfo.put(leader, topicAndPartitions);
                        continue;
                    }
                    topicAndPartitions = new ArrayList();
                    topicAndPartitions.add(new TopicAndPartition(topicMetadata.topic(), partitionMetadata.partitionId()));
                    offsetRequestInfo.put(leader, topicAndPartitions);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to pull requests from Kafka brokers. Exiting the program", (Throwable)e);
            return null;
        }
        ArrayList<CamusRequest> finalRequests = this.fetchLatestOffsetAndCreateKafkaRequests(conf, offsetRequestInfo);
        Collections.sort(finalRequests, new Comparator<CamusRequest>(){

            @Override
            public int compare(CamusRequest r1, CamusRequest r2) {
                return r1.getTopic().compareTo(r2.getTopic());
            }
        });
        log.info((Object)("The requests from kafka metadata are: \n" + finalRequests));
        Map<CamusRequest, KafkaKey> offsetKeys = this.getPreviousOffsets(FileInputFormat.getInputPaths((JobConf)conf), conf);
        Set<String> moveLatest = this.getMoveToLatestTopicsSet(conf);
        for (CamusRequest request : finalRequests) {
            KafkaKey key;
            if (moveLatest.contains(request.getTopic()) || moveLatest.contains("all")) {
                log.info((Object)("Moving to latest for topic: " + request.getTopic()));
                KafkaKey oldKey = offsetKeys.get(request);
                KafkaKey newKey = new KafkaKey(request.getTopic(), ((KafkaRequest)request).getLeaderId(), request.getPartition(), 0L, request.getLastOffset());
                if (oldKey != null) {
                    newKey.setMessageSize(oldKey.getMessageSize());
                }
                offsetKeys.put(request, newKey);
            }
            if ((key = offsetKeys.get(request)) != null) {
                request.setOffset(key.getOffset());
                request.setAvgMsgSize(key.getMessageSize());
            }
            if (request.getEarliestOffset() > request.getOffset() || request.getOffset() > request.getLastOffset()) {
                if (request.getEarliestOffset() > request.getOffset()) {
                    log.error((Object)("The earliest offset was found to be more than the current offset: " + request));
                    log.error((Object)"Moving to the earliest offset available");
                } else {
                    log.error((Object)("The current offset was found to be more than the latest offset: " + request));
                    log.error((Object)"Moving to the earliest offset available");
                }
                request.setOffset(request.getEarliestOffset());
                offsetKeys.put(request, new KafkaKey(request.getTopic(), ((KafkaRequest)request).getLeaderId(), request.getPartition(), 0L, request.getOffset()));
            }
            log.info((Object)request);
        }
        WorkAllocator allocator = KafkaInputFormat.getWorkAllocator(conf);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)conf.getValByRegex(".*"));
        allocator.init(props);
        return allocator.allocateWork(finalRequests, conf);
    }

    private Set<String> getMoveToLatestTopicsSet(JobConf conf) {
        HashSet<String> topics = new HashSet<String>();
        String[] arr = KafkaInputFormat.getMoveToLatestTopics(conf);
        if (arr != null) {
            for (String topic : arr) {
                topics.add(topic);
            }
        }
        return topics;
    }

    private boolean createMessageDecoder(JobConf conf, String topic) {
        try {
            MessageDecoderFactory.createMessageDecoder(conf, topic);
            return true;
        }
        catch (Exception e) {
            log.error((Object)"failed to create decoder", (Throwable)e);
            return false;
        }
    }

    private Map<CamusRequest, KafkaKey> getPreviousOffsets(Path[] inputs, JobConf conf) throws IOException {
        HashMap<CamusRequest, KafkaKey> offsetKeysMap = new HashMap<CamusRequest, KafkaKey>();
        for (Path input : inputs) {
            FileSystem fs = input.getFileSystem((Configuration)conf);
            for (FileStatus f : fs.listStatus(input, (PathFilter)new OffsetFileFilter())) {
                log.info((Object)("previous offset file:" + f.getPath().toString()));
                SequenceFile.Reader reader = new SequenceFile.Reader(fs, f.getPath(), (Configuration)conf);
                KafkaKey key = new KafkaKey();
                while (reader.next((Writable)key, (Writable)NullWritable.get())) {
                    KafkaRequest request = new KafkaRequest(conf, key.getTopic(), key.getLeaderId(), key.getPartition());
                    if (offsetKeysMap.containsKey(request)) {
                        KafkaKey oldKey = (KafkaKey)offsetKeysMap.get(request);
                        if (oldKey.getOffset() < key.getOffset()) {
                            offsetKeysMap.put(request, key);
                        }
                    } else {
                        offsetKeysMap.put(request, key);
                    }
                    key = new KafkaKey();
                }
                reader.close();
            }
        }
        return offsetKeysMap;
    }

    public static void setWorkAllocator(JobContext job, Class<WorkAllocator> val) {
        job.getConfiguration().setClass(CAMUS_WORK_ALLOCATOR_CLASS, val, WorkAllocator.class);
    }

    public static WorkAllocator getWorkAllocator(JobConf job) {
        try {
            return (WorkAllocator)job.getClass(BaseAllocator.class.getName(), BaseAllocator.class).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setMoveToLatestTopics(JobContext job, String val) {
        job.getConfiguration().set(KAFKA_MOVE_TO_LAST_OFFSET_LIST, val);
    }

    public static String[] getMoveToLatestTopics(JobConf job) {
        return job.getStrings(KAFKA_MOVE_TO_LAST_OFFSET_LIST);
    }

    public static void setKafkaClientBufferSize(JobContext job, int val) {
        job.getConfiguration().setInt(KAFKA_CLIENT_BUFFER_SIZE, val);
    }

    public static int getKafkaClientBufferSize(JobContext job) {
        return job.getConfiguration().getInt(KAFKA_CLIENT_BUFFER_SIZE, 0x200000);
    }

    public static void setKafkaClientTimeout(JobContext job, int val) {
        job.getConfiguration().setInt(KAFKA_CLIENT_SO_TIMEOUT, val);
    }

    public static int getKafkaClientTimeout(JobContext job) {
        return job.getConfiguration().getInt(KAFKA_CLIENT_SO_TIMEOUT, 60000);
    }

    public static void setKafkaMaxPullHrs(JobContext job, int val) {
        job.getConfiguration().setInt(KAFKA_MAX_PULL_HRS, val);
    }

    public static int getKafkaMaxPullHrs(JobContext job) {
        return job.getConfiguration().getInt(KAFKA_MAX_PULL_HRS, -1);
    }

    public static void setKafkaMaxPullMinutesPerTask(JobContext job, int val) {
        job.getConfiguration().setInt(KAFKA_MAX_PULL_MINUTES_PER_TASK, val);
    }

    public static int getKafkaMaxPullMinutesPerTask(JobContext job) {
        return job.getConfiguration().getInt(KAFKA_MAX_PULL_MINUTES_PER_TASK, -1);
    }

    public static void setKafkaMaxHistoricalDays(JobContext job, int val) {
        job.getConfiguration().setInt(KAFKA_MAX_HISTORICAL_DAYS, val);
    }

    public static int getKafkaMaxHistoricalDays(JobContext job) {
        return job.getConfiguration().getInt(KAFKA_MAX_HISTORICAL_DAYS, -1);
    }

    public static void setKafkaBlacklistTopic(JobContext job, String val) {
        job.getConfiguration().set(KAFKA_BLACKLIST_TOPIC, val);
    }

    public static String[] getKafkaBlacklistTopic(JobConf job) {
        if (job.get(KAFKA_BLACKLIST_TOPIC) != null && !job.get(KAFKA_BLACKLIST_TOPIC).isEmpty()) {
            return job.getStrings(KAFKA_BLACKLIST_TOPIC);
        }
        return new String[0];
    }

    public static void setKafkaWhitelistTopic(JobContext job, String val) {
        job.getConfiguration().set(KAFKA_WHITELIST_TOPIC, val);
    }

    public static String[] getKafkaWhitelistTopic(JobConf job) {
        if (job.get(KAFKA_WHITELIST_TOPIC) != null && !job.get(KAFKA_WHITELIST_TOPIC).isEmpty()) {
            return job.getStrings(KAFKA_WHITELIST_TOPIC);
        }
        return new String[0];
    }

    public static void setKafkaIgnoreSchemaErrors(JobContext job, boolean val) {
        job.getConfiguration().setBoolean(ETL_IGNORE_SCHEMA_ERRORS, val);
    }

    public static boolean getKafkaIgnoreSchemaErrors(JobContext job) {
        return job.getConfiguration().getBoolean(ETL_IGNORE_SCHEMA_ERRORS, false);
    }

    public static void setKafkaAuditIgnoreServiceTopicList(JobContext job, String topics) {
        job.getConfiguration().set(ETL_AUDIT_IGNORE_SERVICE_TOPIC_LIST, topics);
    }

    public static void setMessageDecoderClass(JobContext job, Class<MessageDecoder> cls) {
        job.getConfiguration().setClass(CAMUS_MESSAGE_DECODER_CLASS, cls, MessageDecoder.class);
    }

    public static Class<MessageDecoder> getMessageDecoderClass(JobContext job) {
        return job.getConfiguration().getClass(CAMUS_MESSAGE_DECODER_CLASS, KafkaAvroMessageDecoder.class);
    }

    private class OffsetFileFilter
    implements PathFilter {
        private OffsetFileFilter() {
        }

        public boolean accept(Path arg0) {
            return arg0.getName().startsWith("kafka_offset_");
        }
    }
}

