/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka;

import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.log4j.Logger;

public class KafkaBackedTableProperties {
    private static final Logger LOG = Logger.getLogger(KafkaBackedTableProperties.class);
    public static final String KAFKA_URI = "kafka.service.uri";
    public static final String KAFKA_URL = "kafka.service.url";
    public static final String KAFKA_PORT = "kafka.service.port";
    public static final String KAFKA_WHITELIST_TOPICS = "kafka.whitelist.topics";
    public static final String KAFKA_AVRO_SCHEMA_FILE = "kafka.avro.schema.file";
    public static final String COLUMN_NAMES = "columns";
    public static final String COLUMN_TYPES = "columns.types";
    public static final String COLUMN_COMMENTS = "columns.comments";

    public void initialize(Properties tableProperties, Map<String, String> jobProperties, TableDesc tableDesc) {
        String kafkaWhitelistTopics = tableProperties.getProperty(KAFKA_WHITELIST_TOPICS);
        LOG.debug((Object)("Kafka whitelist topics : " + kafkaWhitelistTopics));
        jobProperties.put(KAFKA_WHITELIST_TOPICS, kafkaWhitelistTopics);
        String kafkaAvroSchemaFile = tableProperties.getProperty(KAFKA_AVRO_SCHEMA_FILE, null);
        if (kafkaAvroSchemaFile != null) {
            LOG.debug((Object)("Kafka avro schema file : " + kafkaAvroSchemaFile));
            jobProperties.put(KAFKA_AVRO_SCHEMA_FILE, kafkaAvroSchemaFile);
        }
        String kafkaUri = tableProperties.getProperty(KAFKA_URI);
        LOG.debug((Object)("Kafka URI : " + kafkaUri));
        jobProperties.put(KAFKA_URI, kafkaUri);
        String[] uriSplits = kafkaUri.split(":");
        String kafkaUrl = uriSplits[0];
        String kafkaPort = uriSplits[1];
        LOG.debug((Object)("Kafka URL : " + kafkaUrl));
        jobProperties.put(KAFKA_URL, kafkaUrl);
        LOG.debug((Object)("Kafka PORT : " + kafkaPort));
        jobProperties.put(KAFKA_PORT, kafkaPort);
        String columnNames = tableProperties.getProperty(COLUMN_NAMES);
        LOG.debug((Object)("Column Names : " + columnNames));
        jobProperties.put(COLUMN_NAMES, columnNames);
        String columnTypes = tableProperties.getProperty(COLUMN_TYPES);
        LOG.debug((Object)("Column Types : " + columnTypes));
        jobProperties.put(COLUMN_TYPES, columnTypes);
        String columnComments = tableProperties.getProperty(COLUMN_COMMENTS);
        LOG.debug((Object)("Column Comments : " + columnComments));
        jobProperties.put(COLUMN_COMMENTS, columnComments);
    }
}

