/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.CassandraValidatorObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.Text;

public class CassandraLazyValidator
extends LazyPrimitive<CassandraValidatorObjectInspector, Text> {
    private final AbstractType validator;

    public CassandraLazyValidator(CassandraValidatorObjectInspector oi) {
        super((ObjectInspector)oi);
        this.validator = oi.getValidatorType();
        this.data = new Text();
    }

    public CassandraLazyValidator(CassandraLazyValidator copy) {
        super(copy.getInspector());
        this.validator = copy.validator;
        this.isNull = copy.isNull;
    }

    public void init(ByteArrayRef bytes, int start, int length) {
        try {
            ByteBuffer buf = ByteBuffer.wrap(bytes.getData(), start, length);
            ((Text)this.data).set(this.validator.getString(buf));
            this.isNull = false;
        }
        catch (Throwable t) {
            this.isNull = true;
        }
    }
}

