/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql.jdbc.JdbcBoolean;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyBoolean;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyBooleanObjectInspector;
import org.apache.hadoop.io.BooleanWritable;

public class CassandraLazyBoolean
extends LazyBoolean {
    public CassandraLazyBoolean(LazyBooleanObjectInspector oi) {
        super(oi);
    }

    public void init(ByteArrayRef bytes, int start, int length) {
        if (length == 1) {
            try {
                ByteBuffer buf = ByteBuffer.wrap(bytes.getData(), start, length);
                ((BooleanWritable)this.data).set(JdbcBoolean.instance.compose(buf).booleanValue());
                this.isNull = false;
                return;
            }
            catch (Throwable ie) {
                this.isNull = true;
            }
        }
        super.init(bytes, start, length);
    }
}

