/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cassandra.serde;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.hive.cassandra.output.CassandraColumn;
import org.apache.hadoop.hive.cassandra.output.CassandraPut;
import org.apache.hadoop.hive.cassandra.output.CassandraSuperPut;
import org.apache.hadoop.hive.cassandra.serde.TableMapping;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.io.Writable;

public class TransposedMapping
extends TableMapping {
    private int columnName = -1;
    private int columnValue = -1;
    private int subColumnName = -1;

    public TransposedMapping(String colFamily, List<String> columnNames, LazySimpleSerDe.SerDeParameters serdeParams) throws SerDeException {
        super(colFamily, columnNames, serdeParams);
        this.init();
    }

    private void init() throws SerDeException {
        this.setTransposedTableIndex();
    }

    @Override
    public Writable write(byte[] keyBytes, List<? extends StructField> fields, List<Object> list, List<? extends StructField> declaredFields) throws IOException {
        assert (this.columnName >= 0);
        assert (this.columnValue >= 0);
        if (this.subColumnName == -1) {
            CassandraPut put = new CassandraPut(ByteBuffer.wrap(keyBytes));
            CassandraColumn cc = new CassandraColumn();
            cc.setTimeStamp(System.currentTimeMillis());
            cc.setColumnFamily(this.cassandraColumnFamily);
            cc.setColumn(this.serializeToBytes(this.columnName, fields, list, declaredFields));
            cc.setValue(this.serializeToBytes(this.columnValue, fields, list, declaredFields));
            put.getColumns().add(cc);
            return put;
        }
        CassandraSuperPut put = new CassandraSuperPut(ByteBuffer.wrap(keyBytes));
        byte[] colName = this.serializeToBytes(fields.get(this.columnName).getFieldObjectInspector(), declaredFields.get(this.columnName).getFieldObjectInspector(), list.get(this.columnName), this.useJsonSerialize(this.columnName, declaredFields));
        CassandraPut column = new CassandraPut(ByteBuffer.wrap(colName));
        CassandraColumn cc = new CassandraColumn();
        cc.setTimeStamp(System.currentTimeMillis());
        cc.setColumnFamily(this.cassandraColumnFamily);
        cc.setColumn(this.serializeToBytes(this.subColumnName, fields, list, declaredFields));
        cc.setValue(this.serializeToBytes(this.columnValue, fields, list, declaredFields));
        column.getColumns().add(cc);
        put.getColumns().add(column);
        return put;
    }

    private void setTransposedTableIndex() throws SerDeException {
        int key = -1;
        int columnName = -1;
        int columnValue = -1;
        int subColumnName = -1;
        for (int i = 0; i < this.cassandraColumnNames.size(); ++i) {
            String str = (String)this.cassandraColumnNames.get(i);
            if (str.equals(":key")) {
                key = i;
                continue;
            }
            if (str.equals(":column")) {
                columnName = i;
                continue;
            }
            if (str.equals(":value")) {
                columnValue = i;
                continue;
            }
            if (str.equals(":subcolumn")) {
                subColumnName = i;
                continue;
            }
            throw new SerDeException("An expected mapping appears in the column mapping " + str);
        }
        if (key >= 0 && columnName >= 0 && columnValue >= 0) {
            if (subColumnName != -1) {
                this.subColumnName = subColumnName;
            }
            this.columnName = columnName;
            this.columnValue = columnValue;
        }
    }
}

