/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cassandra.serde;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazyCassandraUtils;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;

public abstract class TableMapping {
    protected final List<String> cassandraColumnNames;
    protected final int iKey;
    protected final String cassandraColumnFamily;
    private boolean useJSONSerialize;
    protected final ByteStream.Output serializeStream = new ByteStream.Output();
    private final byte[] separators;
    private final boolean escaped;
    private final byte escapeChar;
    private final boolean[] needsEscape;

    TableMapping(String colFamily, List<String> columnNames, LazySimpleSerDe.SerDeParameters serdeParams) {
        this.cassandraColumnFamily = colFamily;
        this.cassandraColumnNames = columnNames;
        this.iKey = this.cassandraColumnNames.indexOf(":key");
        this.separators = serdeParams.getSeparators();
        this.escaped = serdeParams.isEscaped();
        this.escapeChar = serdeParams.getEscapeChar();
        this.needsEscape = serdeParams.getNeedsEscape();
    }

    public Writable getWritable(List<? extends StructField> fields, List<Object> list, List<? extends StructField> declaredFields) throws IOException {
        assert (this.iKey >= 0);
        byte[] keyBytes = this.serializeToBytes(this.iKey, fields, list, declaredFields);
        return this.write(keyBytes, fields, list, declaredFields);
    }

    public abstract Writable write(byte[] var1, List<? extends StructField> var2, List<Object> var3, List<? extends StructField> var4) throws IOException;

    protected byte[] serializeToBytes(int index, List<? extends StructField> fields, List<Object> list, List<? extends StructField> declaredFields) throws IOException {
        return this.serializeToBytes(fields.get(index).getFieldObjectInspector(), declaredFields.get(index).getFieldObjectInspector(), list.get(index), this.useJsonSerialize(index, declaredFields));
    }

    protected boolean useJsonSerialize(int index, List<? extends StructField> declaredFields) {
        return declaredFields == null || declaredFields.get(index).getFieldObjectInspector().getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) || this.useJSONSerialize;
    }

    protected byte[] serializeToBytes(ObjectInspector foi, ObjectInspector doi, Object obj, boolean useJsonSerialize) throws IOException {
        this.serializeStream.reset();
        boolean isNotNull = !foi.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) && useJsonSerialize ? this.serialize(SerDeUtils.getJSONString((Object)obj, (ObjectInspector)foi), (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, doi, 1) : this.serialize(obj, foi, doi, 1);
        if (!isNotNull) {
            return null;
        }
        byte[] key = new byte[this.serializeStream.getCount()];
        System.arraycopy(this.serializeStream.getData(), 0, key, 0, this.serializeStream.getCount());
        return key;
    }

    protected boolean serialize(Object obj, ObjectInspector objInspector, ObjectInspector declaredObjInspector, int level) throws IOException {
        switch (objInspector.getCategory()) {
            case PRIMITIVE: {
                AbstractType validator = LazyCassandraUtils.getCassandraType((PrimitiveObjectInspector)declaredObjInspector);
                if (validator instanceof BytesType) {
                    BytesWritable bw = ((BinaryObjectInspector)objInspector).getPrimitiveWritableObject(obj);
                    this.serializeStream.write(bw.getBytes(), 0, bw.getLength());
                } else {
                    LazyUtils.writePrimitiveUTF8((OutputStream)this.serializeStream, (Object)obj, (PrimitiveObjectInspector)((PrimitiveObjectInspector)objInspector), (boolean)this.escaped, (byte)this.escapeChar, (boolean[])this.needsEscape);
                    if (!declaredObjInspector.getTypeName().equals(PrimitiveObjectInspectorUtils.stringTypeEntry.typeName)) {
                        ByteBuffer bb = validator.fromString(this.serializeStream.toString());
                        this.serializeStream.reset();
                        this.serializeStream.write(ByteBufferUtil.getArray((ByteBuffer)bb));
                    }
                }
                return true;
            }
            case LIST: {
                char separator = (char)this.separators[level];
                ListObjectInspector loi = (ListObjectInspector)objInspector;
                List list = loi.getList(obj);
                ObjectInspector eoi = loi.getListElementObjectInspector();
                if (list == null) {
                    return false;
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        this.serializeStream.write((int)separator);
                    }
                    this.serialize(list.get(i), eoi, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, level + 1);
                }
                return true;
            }
            case MAP: {
                char separator = (char)this.separators[level];
                char keyValueSeparator = (char)this.separators[level + 1];
                MapObjectInspector moi = (MapObjectInspector)objInspector;
                ObjectInspector koi = moi.getMapKeyObjectInspector();
                ObjectInspector voi = moi.getMapValueObjectInspector();
                Map map = moi.getMap(obj);
                if (map == null) {
                    return false;
                }
                boolean first = true;
                for (Map.Entry entry : map.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        this.serializeStream.write((int)separator);
                    }
                    this.serialize(entry.getKey(), koi, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, level + 2);
                    this.serializeStream.write((int)keyValueSeparator);
                    this.serialize(entry.getValue(), voi, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, level + 2);
                }
                return true;
            }
            case STRUCT: {
                char separator = (char)this.separators[level];
                StructObjectInspector soi = (StructObjectInspector)objInspector;
                List fields = soi.getAllStructFieldRefs();
                List list = soi.getStructFieldsDataAsList(obj);
                if (list == null) {
                    return false;
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        this.serializeStream.write((int)separator);
                    }
                    this.serialize(list.get(i), ((StructField)fields.get(i)).getFieldObjectInspector(), (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, level + 1);
                }
                return true;
            }
        }
        throw new RuntimeException("Unknown category type: " + objInspector.getCategory());
    }
}

