/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cassandra.serde;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.cassandra.output.CassandraColumn;
import org.apache.hadoop.hive.cassandra.output.CassandraPut;
import org.apache.hadoop.hive.cassandra.serde.TableMapping;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.io.Writable;

public class RegularTableMapping
extends TableMapping {
    public RegularTableMapping(String colFamily, List<String> columnNames, LazySimpleSerDe.SerDeParameters serdeParams) {
        super(colFamily, columnNames, serdeParams);
    }

    @Override
    public Writable write(byte[] keyBytes, List<? extends StructField> fields, List<Object> list, List<? extends StructField> declaredFields) throws IOException {
        CassandraPut put = new CassandraPut(ByteBuffer.wrap(keyBytes));
        for (int i = 0; i < this.cassandraColumnNames.size(); ++i) {
            if (i == this.iKey) continue;
            String cassandraColumn = (String)this.cassandraColumnNames.get(i);
            ObjectInspector foi = fields.get(i).getFieldObjectInspector();
            ObjectInspector doi = declaredFields.get(i).getFieldObjectInspector();
            Object f = null;
            if (list == null) {
                return null;
            }
            assert (i < list.size());
            f = list.get(i);
            if (cassandraColumn.endsWith(":")) {
                MapObjectInspector moi = (MapObjectInspector)foi;
                ObjectInspector koi = moi.getMapKeyObjectInspector();
                ObjectInspector voi = moi.getMapValueObjectInspector();
                Map map = moi.getMap(f);
                if (map == null) {
                    return null;
                }
                for (Map.Entry entry : map.entrySet()) {
                    this.serializeStream.reset();
                    this.serialize(entry.getKey(), koi, koi, 3);
                    byte[] columnQualifier = new byte[this.serializeStream.getCount()];
                    System.arraycopy(this.serializeStream.getData(), 0, columnQualifier, 0, this.serializeStream.getCount());
                    this.serializeStream.reset();
                    boolean isNotNull = this.serialize(entry.getValue(), voi, voi, 3);
                    if (!isNotNull) continue;
                    byte[] value = new byte[this.serializeStream.getCount()];
                    System.arraycopy(this.serializeStream.getData(), 0, value, 0, this.serializeStream.getCount());
                    CassandraColumn cc = new CassandraColumn();
                    cc.setTimeStamp(System.currentTimeMillis());
                    cc.setColumnFamily(this.cassandraColumnFamily);
                    cc.setColumn(columnQualifier);
                    cc.setValue(value);
                    put.getColumns().add(cc);
                }
                continue;
            }
            CassandraColumn cc = new CassandraColumn();
            cc.setTimeStamp(System.currentTimeMillis());
            cc.setColumnFamily(this.cassandraColumnFamily);
            cc.setColumn(cassandraColumn.getBytes());
            byte[] key = this.serializeToBytes(foi, doi, f, this.useJsonSerialize(i, declaredFields));
            cc.setValue(key);
            put.getColumns().add(cc);
        }
        return put;
    }
}

