/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cassandra.serde;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.hadoop.hive.serde2.lazy.CassandraLazyBinary;
import org.apache.hadoop.hive.serde2.lazy.CassandraLazyBoolean;
import org.apache.hadoop.hive.serde2.lazy.CassandraLazyDouble;
import org.apache.hadoop.hive.serde2.lazy.CassandraLazyFloat;
import org.apache.hadoop.hive.serde2.lazy.CassandraLazyInteger;
import org.apache.hadoop.hive.serde2.lazy.CassandraLazyLong;
import org.apache.hadoop.hive.serde2.lazy.CassandraLazyTimestamp;
import org.apache.hadoop.hive.serde2.lazy.CassandraLazyValidator;
import org.apache.hadoop.hive.serde2.lazy.LazyByte;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.hadoop.hive.serde2.lazy.LazyShort;
import org.apache.hadoop.hive.serde2.lazy.LazyString;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.CassandraValidatorObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyByteObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyFloatObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyIntObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyLongObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyShortObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyStringObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.Text;

public class CassandraLazyFactory {
    public static LazyObject createLazyPrimitiveClass(PrimitiveObjectInspector oi) {
        PrimitiveObjectInspector.PrimitiveCategory p = oi.getPrimitiveCategory();
        switch (p) {
            case BOOLEAN: {
                return new CassandraLazyBoolean((LazyBooleanObjectInspector)oi);
            }
            case BYTE: {
                return new LazyByte((LazyByteObjectInspector)oi);
            }
            case SHORT: {
                return new LazyShort((LazyShortObjectInspector)oi);
            }
            case INT: {
                return new CassandraLazyInteger((LazyIntObjectInspector)oi);
            }
            case LONG: {
                return new CassandraLazyLong((LazyLongObjectInspector)oi);
            }
            case FLOAT: {
                return new CassandraLazyFloat((LazyFloatObjectInspector)oi);
            }
            case DOUBLE: {
                return new CassandraLazyDouble((LazyDoubleObjectInspector)oi);
            }
            case STRING: {
                return new LazyString((LazyStringObjectInspector)oi);
            }
            case BINARY: {
                return new CassandraLazyBinary((LazyBinaryObjectInspector)oi);
            }
            case TIMESTAMP: {
                return new CassandraLazyTimestamp((LazyTimestampObjectInspector)oi);
            }
        }
        throw new RuntimeException("Internal error: no LazyObject for " + p);
    }

    public static LazyObject createLazyObject(ObjectInspector oi) {
        if (oi instanceof CassandraValidatorObjectInspector) {
            return new CassandraLazyValidator((CassandraValidatorObjectInspector)oi);
        }
        ObjectInspector.Category c = oi.getCategory();
        switch (c) {
            case PRIMITIVE: {
                return CassandraLazyFactory.createLazyPrimitiveClass((PrimitiveObjectInspector)oi);
            }
            case MAP: 
            case LIST: 
            case STRUCT: 
            case UNION: {
                return LazyFactory.createLazyObject((ObjectInspector)oi);
            }
        }
        throw new RuntimeException("Hive LazySerDe Internal error.");
    }

    public static ObjectInspector createLazyObjectInspector(TypeInfo typeInfo, AbstractType validator, byte[] separator, int separatorIndex, Text nullSequence, boolean escaped, byte escapeChar) {
        return new CassandraValidatorObjectInspector(validator);
    }

    public static ObjectInspector createLazyStructInspector(List<String> columnNames, List<TypeInfo> typeInfos, List<AbstractType> validatorTypes, byte[] separators, Text nullSequence, boolean lastColumnTakesRest, boolean escaped, byte escapeChar) {
        if (validatorTypes.size() == 0) {
            return LazyFactory.createLazyStructInspector(columnNames, typeInfos, (byte[])separators, (Text)nullSequence, (boolean)lastColumnTakesRest, (boolean)escaped, (byte)escapeChar);
        }
        ArrayList<ObjectInspector> columnObjectInspectors = new ArrayList<ObjectInspector>(validatorTypes.size());
        for (int i = 0; i < validatorTypes.size(); ++i) {
            columnObjectInspectors.add(CassandraLazyFactory.createLazyObjectInspector(typeInfos.get(i), validatorTypes.get(i), separators, 1, nullSequence, escaped, escapeChar));
        }
        return LazyObjectInspectorFactory.getLazySimpleStructObjectInspector(columnNames, columnObjectInspectors, (byte)separators[0], (Text)nullSequence, (boolean)lastColumnTakesRest, (boolean)escaped, (byte)escapeChar);
    }
}

