/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cassandra.serde;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cassandra.input.LazyCassandraRow;
import org.apache.hadoop.hive.cassandra.output.CassandraPut;
import org.apache.hadoop.hive.cassandra.serde.RegularTableMapping;
import org.apache.hadoop.hive.cassandra.serde.TableMapping;
import org.apache.hadoop.hive.cassandra.serde.TransposedMapping;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Writable;

public abstract class AbstractColumnSerDe
implements SerDe {
    public static final Log LOG = LogFactory.getLog((String)AbstractColumnSerDe.class.getName());
    public static final String CASSANDRA_KEYSPACE_NAME = "cassandra.ks.name";
    public static final String CASSANDRA_KEYSPACE_REPFACTOR = "cassandra.ks.repfactor";
    public static final String CASSANDRA_KEYSPACE_STRATEGY = "cassandra.ks.strategy";
    public static final String CASSANDRA_CF_NAME = "cassandra.cf.name";
    public static final String CASSANDRA_CF_COUNTERS = "cassandra.cf.counters";
    public static final String CASSANDRA_RANGE_BATCH_SIZE = "cassandra.range.size";
    public static final String CASSANDRA_SLICE_PREDICATE_SIZE = "cassandra.slice.predicate.size";
    public static final String CASSANDRA_SPLIT_SIZE = "cassandra.input.split.size";
    public static final String CASSANDRA_HOST = "cassandra.host";
    public static final String CASSANDRA_PORT = "cassandra.port";
    public static final String CASSANDRA_PARTITIONER = "cassandra.partitioner";
    public static final String CASSANDRA_COL_MAPPING = "cassandra.columns.mapping";
    public static final String CASSANDRA_BATCH_MUTATION_SIZE = "cassandra.batchmutate.size";
    public static final String CASSANDRA_SLICE_PREDICATE_COLUMN_NAMES = "cassandra.slice.predicate.column_names";
    public static final String CASSANDRA_SLICE_PREDICATE_RANGE_START = "cassandra.slice.predicate.range.start";
    public static final String CASSANDRA_SLICE_PREDICATE_RANGE_FINISH = "cassandra.slice.predicate.range.finish";
    public static final String CASSANDRA_SLICE_PREDICATE_RANGE_COMPARATOR = "cassandra.slice.predicate.range.comparator";
    public static final String CASSANDRA_SLICE_PREDICATE_RANGE_REVERSED = "cassandra.slice.predicate.range.reversed";
    public static final String CASSANDRA_SLICE_PREDICATE_RANGE_COUNT = "cassandra.slice.predicate.range.count";
    public static final String CASSANDRA_ENABLE_WIDEROW_ITERATOR = "cassandra.enable.widerow.iterator";
    public static final String CASSANDRA_SPECIAL_COLUMN_KEY = "row_key";
    public static final String CASSANDRA_SPECIAL_COLUMN_COL = "column_name";
    public static final String CASSANDRA_SPECIAL_COLUMN_SCOL = "sub_column_name";
    public static final String CASSANDRA_SPECIAL_COLUMN_VAL = "value";
    public static final String CASSANDRA_KEY_COLUMN = ":key";
    public static final String CASSANDRA_COLUMN_COLUMN = ":column";
    public static final String CASSANDRA_SUBCOLUMN_COLUMN = ":subcolumn";
    public static final String CASSANDRA_VALUE_COLUMN = ":value";
    public static final String CASSANDRA_CONSISTENCY_LEVEL = "cassandra.consistency.level";
    public static final String CASSANDRA_THRIFT_MODE = "cassandra.thrift.mode";
    public static final int DEFAULT_SPLIT_SIZE = 65536;
    public static final int DEFAULT_RANGE_BATCH_SIZE = 1000;
    public static final int DEFAULT_SLICE_PREDICATE_SIZE = 1000;
    public static final String DEFAULT_CASSANDRA_HOST = "localhost";
    public static final String DEFAULT_CASSANDRA_PORT = "9160";
    public static final String DEFAULT_CONSISTENCY_LEVEL = "ONE";
    public static final int DEFAULT_BATCH_MUTATION_SIZE = 500;
    protected List<String> cassandraColumnNames;
    protected int iKey;
    protected TableMapping mapping;
    protected ObjectInspector cachedObjectInspector;
    protected LazySimpleSerDe.SerDeParameters serdeParams;
    protected LazyCassandraRow cachedCassandraRow;
    protected String cassandraColumnFamily;
    protected List<BytesWritable> cassandraColumnNamesBytes;

    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        this.initCassandraSerDeParameters(conf, tbl, this.getClass().getName());
        this.cachedObjectInspector = this.createObjectInspector();
        this.cachedCassandraRow = new LazyCassandraRow((LazySimpleStructObjectInspector)this.cachedObjectInspector);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("CassandraSerDe initialized with : columnNames = " + StringUtils.join((Collection)this.serdeParams.getColumnNames(), (String)",") + " columnTypes = " + StringUtils.join((Collection)this.serdeParams.getColumnTypes(), (String)",") + " cassandraColumnMapping = " + this.cassandraColumnNames));
        }
    }

    protected abstract ObjectInspector createObjectInspector();

    public Object deserialize(Writable w) throws SerDeException {
        if (!(w instanceof MapWritable)) {
            throw new SerDeException(this.getClass().getName() + ": expects MapWritable not " + w.getClass().getName());
        }
        MapWritable columnMap = (MapWritable)w;
        this.cachedCassandraRow.init(columnMap, this.cassandraColumnNames, this.cassandraColumnNamesBytes);
        return this.cachedCassandraRow;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.cachedObjectInspector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return CassandraPut.class;
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (objInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(this.getClass().toString() + " can only serialize struct types, but we got: " + objInspector.getTypeName());
        }
        StructObjectInspector soi = (StructObjectInspector)objInspector;
        List fields = soi.getAllStructFieldRefs();
        List list = soi.getStructFieldsDataAsList(obj);
        List declaredFields = this.serdeParams.getRowTypeInfo() != null && ((StructTypeInfo)this.serdeParams.getRowTypeInfo()).getAllStructFieldNames().size() > 0 ? ((StructObjectInspector)this.getObjectInspector()).getAllStructFieldRefs() : null;
        try {
            assert (this.iKey >= 0);
            return this.mapping.getWritable(fields, list, declaredFields);
        }
        catch (IOException e) {
            throw new SerDeException("Unable to serialize this object! " + e);
        }
    }

    protected abstract void initCassandraSerDeParameters(Configuration var1, Properties var2, String var3) throws SerDeException;

    public static List<String> parseColumnMapping(String columnMapping) {
        assert (StringUtils.isNotBlank((String)columnMapping));
        String[] columnArray = columnMapping.split(",");
        String[] trimmedColumnArray = AbstractColumnSerDe.trim(columnArray);
        List<String> columnList = Arrays.asList(trimmedColumnArray);
        int iKey = columnList.indexOf(CASSANDRA_KEY_COLUMN);
        if (iKey == -1) {
            columnList = new ArrayList<String>(columnList);
            columnList.add(0, CASSANDRA_KEY_COLUMN);
        }
        return columnList;
    }

    public static String createColumnMappingString(String[] colNames) {
        boolean isTransposedTable = true;
        boolean hasKey = false;
        boolean hasVal = false;
        boolean hasCol = false;
        boolean hasSubCol = false;
        String transposedMapping = "";
        for (String column : colNames) {
            if (column.equalsIgnoreCase(CASSANDRA_SPECIAL_COLUMN_KEY)) {
                transposedMapping = transposedMapping + ",:key";
                hasKey = true;
                continue;
            }
            if (column.equalsIgnoreCase(CASSANDRA_SPECIAL_COLUMN_COL)) {
                transposedMapping = transposedMapping + ",:column";
                hasCol = true;
                continue;
            }
            if (column.equalsIgnoreCase(CASSANDRA_SPECIAL_COLUMN_SCOL)) {
                transposedMapping = transposedMapping + ",:subcolumn";
                hasSubCol = true;
                continue;
            }
            if (column.equalsIgnoreCase(CASSANDRA_SPECIAL_COLUMN_VAL)) {
                transposedMapping = transposedMapping + ",:value";
                hasVal = true;
                continue;
            }
            isTransposedTable = false;
            break;
        }
        if (isTransposedTable && (colNames.length != 1 || !hasKey)) {
            if (!(hasKey && hasVal && hasCol)) {
                throw new IllegalArgumentException("Transposed table definition missing required fields!");
            }
            return transposedMapping.substring(1);
        }
        StringBuilder mappingStr = new StringBuilder(CASSANDRA_KEY_COLUMN);
        for (int i = 1; i < colNames.length; ++i) {
            mappingStr.append(",");
            mappingStr.append(colNames[i]);
        }
        return mappingStr.toString();
    }

    public static String createColumnMappingString(String tblColumnStr) {
        if (StringUtils.isBlank((String)tblColumnStr)) {
            throw new IllegalArgumentException("table must have columns");
        }
        String[] colNames = tblColumnStr.split(",");
        return AbstractColumnSerDe.createColumnMappingString(colNames);
    }

    protected String getCassandraColumnFamily(Properties tbl) throws SerDeException {
        String result = tbl.getProperty(CASSANDRA_CF_NAME);
        if (result == null) {
            result = tbl.getProperty("name");
            if (result == null) {
                throw new SerDeException("CassandraColumnFamily not defined" + tbl.toString());
            }
            if (result.indexOf(".") != -1) {
                result = result.substring(result.indexOf(".") + 1);
            }
        }
        return result;
    }

    protected List<String> parseOrCreateColumnMapping(Properties tbl) throws SerDeException {
        String prop = tbl.getProperty(CASSANDRA_COL_MAPPING);
        if (prop != null) {
            return AbstractColumnSerDe.parseColumnMapping(prop);
        }
        String tblColumnStr = tbl.getProperty("columns");
        if (tblColumnStr != null) {
            String mappingStr = AbstractColumnSerDe.createColumnMappingString(tblColumnStr);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("table column string: " + tblColumnStr));
                LOG.debug((Object)("Auto-created mapping string: " + mappingStr));
            }
            return Arrays.asList(mappingStr.split(","));
        }
        throw new SerDeException("Can't find table column definitions");
    }

    protected void setTableMapping() throws SerDeException {
        this.mapping = AbstractColumnSerDe.isTransposed(this.cassandraColumnNames) ? new TransposedMapping(this.cassandraColumnFamily, this.cassandraColumnNames, this.serdeParams) : new RegularTableMapping(this.cassandraColumnFamily, this.cassandraColumnNames, this.serdeParams);
    }

    protected static String[] trim(String[] input) {
        String[] trimmed = new String[input.length];
        for (int i = 0; i < input.length; ++i) {
            trimmed[i] = input[i].trim();
        }
        return trimmed;
    }

    public static boolean isTransposed(List<String> columnNames) {
        if (columnNames == null || columnNames.size() == 0) {
            throw new IllegalArgumentException("no cassandra column information found");
        }
        boolean hasKey = false;
        boolean hasColumn = false;
        boolean hasValue = false;
        boolean hasSubColumn = false;
        for (String column : columnNames) {
            if (column.equalsIgnoreCase(CASSANDRA_KEY_COLUMN)) {
                hasKey = true;
                continue;
            }
            if (column.equalsIgnoreCase(CASSANDRA_COLUMN_COLUMN)) {
                hasColumn = true;
                continue;
            }
            if (column.equalsIgnoreCase(CASSANDRA_SUBCOLUMN_COLUMN)) {
                hasSubColumn = true;
                continue;
            }
            if (column.equalsIgnoreCase(CASSANDRA_VALUE_COLUMN)) {
                hasValue = true;
                continue;
            }
            return false;
        }
        if (columnNames.size() == 1 && hasKey) {
            return false;
        }
        return hasKey && hasValue && hasColumn;
    }

    public int getKeyColumnOffset() {
        return this.iKey;
    }

    public SerDeStats getSerDeStats() {
        return null;
    }

    protected class ColumnData {
        protected ColumnData() {
        }
    }
}

