/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cassandra.input;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.cassandra.input.LazyCassandraCellMap;
import org.apache.hadoop.hive.cassandra.serde.CassandraLazyFactory;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.MapWritable;

public class LazyCassandraRow
extends LazyStruct {
    static final Log LOG = LogFactory.getLog(LazyCassandraRow.class);
    private List<String> cassandraColumns;
    private List<BytesWritable> cassandraColumnsBB;
    private MapWritable columnMap;
    private ArrayList<Object> cachedList;

    public LazyCassandraRow(LazySimpleStructObjectInspector oi) {
        super(oi);
    }

    public void init(MapWritable columnMap, List<String> cassandraColumns, List<BytesWritable> cassandraColumnsBB) {
        this.columnMap = columnMap;
        this.cassandraColumns = cassandraColumns;
        this.cassandraColumnsBB = cassandraColumnsBB;
        if (cassandraColumns.size() != cassandraColumnsBB.size()) {
            throw new IllegalStateException();
        }
        this.setParsed(false);
    }

    private void parse() {
        if (this.getFields() == null) {
            List fieldRefs = ((StructObjectInspector)this.getInspector()).getAllStructFieldRefs();
            this.setFields(new LazyObject[fieldRefs.size()]);
            for (int i = 0; i < this.getFields().length; ++i) {
                String cassandraColumn = this.cassandraColumns.get(i);
                this.getFields()[i] = cassandraColumn.endsWith(":") ? new LazyCassandraCellMap((LazyMapObjectInspector)((StructField)fieldRefs.get(i)).getFieldObjectInspector()) : CassandraLazyFactory.createLazyObject(((StructField)fieldRefs.get(i)).getFieldObjectInspector());
            }
            this.setFieldInited(new boolean[this.getFields().length]);
        }
        Arrays.fill(this.getFieldInited(), false);
        this.setParsed(true);
    }

    public Object getField(int fieldID) {
        if (!this.getParsed()) {
            this.parse();
        }
        return this.uncheckedGetField(fieldID);
    }

    private Object uncheckedGetField(int fieldID) {
        if (!this.getFieldInited()[fieldID]) {
            this.getFieldInited()[fieldID] = true;
            ByteArrayRef ref = null;
            String columnName = this.cassandraColumns.get(fieldID);
            BytesWritable columnNameBB = this.cassandraColumnsBB.get(fieldID);
            LazyObject obj = this.getFields()[fieldID];
            if (columnName.endsWith(":")) {
                return null;
            }
            BytesWritable columnValue = (BytesWritable)this.columnMap.get((Object)columnNameBB);
            if (columnValue == null) {
                return null;
            }
            ref = new ByteArrayRef();
            ref.setData(columnValue.getBytes());
            if (ref != null) {
                obj.init(ref, 0, ref.getData().length);
            }
        }
        return this.getFields()[fieldID].getObject();
    }

    public ArrayList<Object> getFieldsAsList() {
        if (!this.getParsed()) {
            this.parse();
        }
        if (this.cachedList == null) {
            this.cachedList = new ArrayList();
        } else {
            this.cachedList.clear();
        }
        for (int i = 0; i < this.getFields().length; ++i) {
            this.cachedList.add(this.uncheckedGetField(i));
        }
        return this.cachedList;
    }

    public Object getObject() {
        return this;
    }
}

