/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cassandra.input;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.hadoop.ColumnFamilyRecordReader;
import org.apache.cassandra.hadoop.ColumnFamilySplit;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.CounterSuperColumn;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.TBinaryProtocol;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.mortbay.log.Log;

public class ColumnFamilyWideRowRecordReader
extends ColumnFamilyRecordReader {
    public static final int CASSANDRA_HADOOP_MAX_KEY_SIZE_DEFAULT = 8192;
    private ColumnFamilySplit split;
    private WideRowIterator iter;
    private Pair<ByteBuffer, SortedMap<ByteBuffer, IColumn>> currentRow;
    private SlicePredicate predicate;
    private int totalRowCount;
    private int batchRowCount;
    private int rowPageSize;
    private ByteBuffer startSlicePredicate;
    private String cfName;
    private String keyspace;
    private TSocket socket;
    private Cassandra.Client client;
    private ConsistencyLevel consistencyLevel;
    private int keyBufferSize = 8192;

    public ColumnFamilyWideRowRecordReader() {
        this(8192);
    }

    public ColumnFamilyWideRowRecordReader(int keyBufferSize) {
        this.keyBufferSize = keyBufferSize;
    }

    public void close() {
        if (this.socket != null && this.socket.isOpen()) {
            this.socket.close();
            this.socket = null;
            this.client = null;
        }
    }

    public ByteBuffer getCurrentKey() {
        return (ByteBuffer)this.currentRow.left;
    }

    public SortedMap<ByteBuffer, IColumn> getCurrentValue() {
        return (SortedMap)this.currentRow.right;
    }

    public float getProgress() {
        return this.iter.rowsRead() > this.totalRowCount ? 1.0f : (float)this.iter.rowsRead() / (float)this.totalRowCount;
    }

    static boolean isSliceRangePredicate(SlicePredicate predicate) {
        if (predicate == null) {
            return false;
        }
        if (predicate.isSetColumn_names() && predicate.getSlice_range() == null) {
            return false;
        }
        if (predicate.getSlice_range() == null) {
            return false;
        }
        byte[] start = predicate.getSlice_range().getStart();
        byte[] finish = predicate.getSlice_range().getFinish();
        return start != null && finish != null;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
        this.split = (ColumnFamilySplit)split;
        Configuration conf = context.getConfiguration();
        this.predicate = ConfigHelper.getInputSlicePredicate((Configuration)conf);
        if (!ColumnFamilyWideRowRecordReader.isSliceRangePredicate(this.predicate)) {
            throw new AssertionError((Object)"WideRowsRequire a slice range");
        }
        this.totalRowCount = ConfigHelper.getInputSplitSize((Configuration)conf);
        Log.info((String)("total rows = " + this.totalRowCount));
        this.batchRowCount = 1;
        this.rowPageSize = this.predicate.getSlice_range().getCount();
        this.startSlicePredicate = this.predicate.getSlice_range().start;
        this.cfName = ConfigHelper.getInputColumnFamily((Configuration)conf);
        this.consistencyLevel = ConsistencyLevel.valueOf((String)ConfigHelper.getReadConsistencyLevel((Configuration)conf));
        this.keyspace = ConfigHelper.getInputKeyspace((Configuration)conf);
        try {
            if (this.socket != null && this.socket.isOpen()) {
                return;
            }
            String location = this.getLocation();
            this.socket = new TSocket(location, ConfigHelper.getInputRpcPort((Configuration)conf));
            TBinaryProtocol binaryProtocol = new TBinaryProtocol((TTransport)new TFramedTransport((TTransport)this.socket));
            this.client = new Cassandra.Client((TProtocol)binaryProtocol);
            this.socket.open();
            this.client.set_keyspace(this.keyspace);
            if (ConfigHelper.getInputKeyspaceUserName((Configuration)conf) != null) {
                HashMap<String, String> creds = new HashMap<String, String>();
                creds.put("username", ConfigHelper.getInputKeyspaceUserName((Configuration)conf));
                creds.put("password", ConfigHelper.getInputKeyspacePassword((Configuration)conf));
                AuthenticationRequest authRequest = new AuthenticationRequest(creds);
                this.client.login(authRequest);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.iter = new WideRowIterator();
    }

    public boolean nextKeyValue() throws IOException {
        if (!this.iter.hasNext()) {
            return false;
        }
        this.currentRow = (Pair)this.iter.next();
        return true;
    }

    private String getLocation() {
        ArrayList<InetAddress> localAddresses = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            while (nets.hasMoreElements()) {
                localAddresses.addAll(Collections.list(nets.nextElement().getInetAddresses()));
            }
        }
        catch (SocketException e) {
            throw new AssertionError((Object)e);
        }
        for (InetAddress address : localAddresses) {
            for (String location : this.split.getLocations()) {
                InetAddress locationAddress = null;
                try {
                    locationAddress = InetAddress.getByName(location);
                }
                catch (UnknownHostException e) {
                    throw new AssertionError((Object)e);
                }
                if (!address.equals(locationAddress)) continue;
                return location;
            }
        }
        return this.split.getLocations()[0];
    }

    public boolean next(ByteBuffer key, SortedMap<ByteBuffer, IColumn> value) throws IOException {
        if (this.nextKeyValue()) {
            key.clear();
            key.put(this.getCurrentKey());
            key.rewind();
            value.clear();
            value.putAll((Map<ByteBuffer, IColumn>)this.getCurrentValue());
            return true;
        }
        return false;
    }

    public ByteBuffer createKey() {
        return ByteBuffer.wrap(new byte[this.keyBufferSize]);
    }

    public SortedMap<ByteBuffer, IColumn> createValue() {
        return new TreeMap<ByteBuffer, IColumn>();
    }

    public long getPos() throws IOException {
        return this.iter.rowsRead();
    }

    private class WideRowIterator
    extends AbstractIterator<Pair<ByteBuffer, SortedMap<ByteBuffer, IColumn>>> {
        private List<KeySlice> rows;
        private String startToken;
        private int columnsRead = 0;
        private ByteBuffer prevStartSlice = null;
        private int totalRead = 0;
        private final AbstractType comparator;
        private final AbstractType subComparator;
        private final IPartitioner partitioner;

        private WideRowIterator() {
            try {
                this.partitioner = FBUtilities.newPartitioner((String)ColumnFamilyWideRowRecordReader.this.client.describe_partitioner());
                KsDef ks_def = ColumnFamilyWideRowRecordReader.this.client.describe_keyspace(ColumnFamilyWideRowRecordReader.this.keyspace);
                CfDef cf_def = this.findCfDef(ks_def, ColumnFamilyWideRowRecordReader.this.cfName);
                if (cf_def == null) {
                    throw new RuntimeException("ColumnFamily named " + ColumnFamilyWideRowRecordReader.this.cfName + " wasn't found in keyspace " + ks_def.name);
                }
                this.comparator = TypeParser.parse((String)cf_def.comparator_type);
                this.subComparator = cf_def.subcomparator_type == null ? null : TypeParser.parse((String)cf_def.subcomparator_type);
            }
            catch (ConfigurationException e) {
                throw new RuntimeException("unable to load sub/comparator", e);
            }
            catch (TException e) {
                throw new RuntimeException("error communicating via Thrift", e);
            }
            catch (Exception e) {
                throw new RuntimeException("unable to load keyspace " + ColumnFamilyWideRowRecordReader.this.keyspace, e);
            }
        }

        private CfDef findCfDef(KsDef ks_def, String cfName) {
            for (CfDef cfDef : ks_def.cf_defs) {
                if (!cfDef.name.equals(cfName)) continue;
                return cfDef;
            }
            return null;
        }

        private void maybeInit() {
            if (this.rows != null && this.columnsRead < ColumnFamilyWideRowRecordReader.this.rowPageSize) {
                this.columnsRead = 0;
                this.startToken = this.partitioner.getTokenFactory().toString(this.partitioner.getToken(this.rows.get((int)0).key));
                ColumnFamilyWideRowRecordReader.this.predicate.getSlice_range().setStart(ColumnFamilyWideRowRecordReader.this.startSlicePredicate);
                this.rows = null;
                this.prevStartSlice = null;
                ++this.totalRead;
            }
            if (this.startToken == null) {
                this.startToken = ColumnFamilyWideRowRecordReader.this.split.getStartToken();
            } else if (this.startToken.equals(ColumnFamilyWideRowRecordReader.this.split.getEndToken()) && this.rows == null) {
                return;
            }
            KeyRange keyRange = new KeyRange(ColumnFamilyWideRowRecordReader.this.batchRowCount).setStart_token(this.startToken).setEnd_token(ColumnFamilyWideRowRecordReader.this.split.getEndToken());
            try {
                this.rows = ColumnFamilyWideRowRecordReader.this.client.get_range_slices(new ColumnParent(ColumnFamilyWideRowRecordReader.this.cfName), ColumnFamilyWideRowRecordReader.this.predicate, keyRange, ColumnFamilyWideRowRecordReader.this.consistencyLevel);
                if (this.rows.isEmpty()) {
                    this.rows = null;
                    return;
                }
                if (this.prevStartSlice != null && ByteBufferUtil.compareUnsigned((ByteBuffer)this.prevStartSlice, (ByteBuffer)((ColumnFamilyWideRowRecordReader)ColumnFamilyWideRowRecordReader.this).predicate.slice_range.start) == 0) {
                    this.rows = null;
                    return;
                }
                KeySlice row = this.rows.get(0);
                if (row.getColumnsSize() > 0) {
                    ColumnOrSuperColumn cosc = (ColumnOrSuperColumn)row.getColumns().get(row.getColumnsSize() - 1);
                    this.prevStartSlice = ((ColumnFamilyWideRowRecordReader)ColumnFamilyWideRowRecordReader.this).predicate.slice_range.start;
                    if (cosc.column != null) {
                        ((ColumnFamilyWideRowRecordReader)ColumnFamilyWideRowRecordReader.this).predicate.slice_range.start = cosc.column.name;
                    }
                    if (cosc.super_column != null) {
                        ((ColumnFamilyWideRowRecordReader)ColumnFamilyWideRowRecordReader.this).predicate.slice_range.start = cosc.super_column.name;
                    }
                    if (cosc.counter_column != null) {
                        ((ColumnFamilyWideRowRecordReader)ColumnFamilyWideRowRecordReader.this).predicate.slice_range.start = cosc.counter_column.name;
                    }
                    if (cosc.counter_super_column != null) {
                        ((ColumnFamilyWideRowRecordReader)ColumnFamilyWideRowRecordReader.this).predicate.slice_range.start = cosc.counter_super_column.name;
                    }
                    this.columnsRead = row.getColumnsSize();
                    if (this.columnsRead == ColumnFamilyWideRowRecordReader.this.rowPageSize) {
                        row.getColumns().remove(this.columnsRead - 1);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public int rowsRead() {
            return this.totalRead;
        }

        protected Pair<ByteBuffer, SortedMap<ByteBuffer, IColumn>> computeNext() {
            this.maybeInit();
            if (this.rows == null) {
                return (Pair)this.endOfData();
            }
            KeySlice ks = this.rows.get(0);
            TreeMap<ByteBuffer, IColumn> map = new TreeMap<ByteBuffer, IColumn>((Comparator<ByteBuffer>)this.comparator);
            for (ColumnOrSuperColumn cosc : ks.columns) {
                IColumn column = this.unthriftify(cosc);
                map.put(column.name(), column);
            }
            return Pair.create((Object)ks.key, map);
        }

        private IColumn unthriftify(ColumnOrSuperColumn cosc) {
            if (cosc.counter_column != null) {
                return this.unthriftifyCounter(cosc.counter_column);
            }
            if (cosc.counter_super_column != null) {
                return this.unthriftifySuperCounter(cosc.counter_super_column);
            }
            if (cosc.super_column != null) {
                return this.unthriftifySuper(cosc.super_column);
            }
            assert (cosc.column != null);
            return this.unthriftifySimple(cosc.column);
        }

        private IColumn unthriftifySuper(org.apache.cassandra.thrift.SuperColumn super_column) {
            SuperColumn sc = new SuperColumn(super_column.name, this.subComparator);
            for (org.apache.cassandra.thrift.Column column : super_column.columns) {
                sc.addColumn(this.unthriftifySimple(column));
            }
            return sc;
        }

        private IColumn unthriftifySimple(org.apache.cassandra.thrift.Column column) {
            return new Column(column.name, column.value, column.timestamp);
        }

        private IColumn unthriftifyCounter(CounterColumn column) {
            return new Column(column.name, ByteBufferUtil.bytes((long)column.value), 0L);
        }

        private IColumn unthriftifySuperCounter(CounterSuperColumn superColumn) {
            SuperColumn sc = new SuperColumn(superColumn.name, this.subComparator);
            for (CounterColumn column : superColumn.columns) {
                sc.addColumn(this.unthriftifyCounter(column));
            }
            return sc;
        }
    }
}

