/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cassandra.input;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.hadoop.ColumnFamilyRecordReader;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class CassandraHiveRecordReader
extends RecordReader<BytesWritable, MapWritable>
implements org.apache.hadoop.mapred.RecordReader<BytesWritable, MapWritable> {
    static final Log LOG = LogFactory.getLog(CassandraHiveRecordReader.class);
    private final boolean isTransposed;
    private final ColumnFamilyRecordReader cfrr;
    private Iterator<Map.Entry<ByteBuffer, IColumn>> columnIterator = null;
    private Map.Entry<ByteBuffer, IColumn> currentEntry;
    private Iterator<IColumn> subColumnIterator = null;
    private BytesWritable currentKey = null;
    private final MapWritable currentValue = new MapWritable();
    public static final BytesWritable keyColumn = new BytesWritable(":key".getBytes());
    public static final BytesWritable columnColumn = new BytesWritable(":column".getBytes());
    public static final BytesWritable subColumnColumn = new BytesWritable(":subcolumn".getBytes());
    public static final BytesWritable valueColumn = new BytesWritable(":value".getBytes());

    public CassandraHiveRecordReader(ColumnFamilyRecordReader cfrr, boolean isTransposed) {
        this.cfrr = cfrr;
        this.isTransposed = isTransposed;
    }

    public void close() throws IOException {
        this.cfrr.close();
    }

    public BytesWritable createKey() {
        return new BytesWritable();
    }

    public MapWritable createValue() {
        return new MapWritable();
    }

    public long getPos() throws IOException {
        return this.cfrr.getPos();
    }

    public float getProgress() throws IOException {
        return this.cfrr.getProgress();
    }

    public boolean next(BytesWritable key, MapWritable value) throws IOException {
        if (!this.nextKeyValue()) {
            return false;
        }
        key.set(this.getCurrentKey());
        value.clear();
        value.putAll((Map)this.getCurrentValue());
        return true;
    }

    public BytesWritable getCurrentKey() {
        return this.currentKey;
    }

    public MapWritable getCurrentValue() {
        return this.currentValue;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
        this.cfrr.initialize(split, context);
    }

    private BytesWritable convertByteBuffer(ByteBuffer val) {
        return new BytesWritable(ByteBufferUtil.getArray((ByteBuffer)val));
    }

    public boolean nextKeyValue() throws IOException {
        boolean next;
        block12: {
            next = false;
            if (this.isTransposed) {
                Map.Entry<ByteBuffer, IColumn> entry;
                block13: {
                    do {
                        if (!(this.columnIterator != null && this.columnIterator.hasNext() || this.subColumnIterator != null && this.subColumnIterator.hasNext())) {
                            next = this.cfrr.nextKeyValue();
                            if (next) {
                                this.columnIterator = this.cfrr.getCurrentValue().entrySet().iterator();
                                this.subColumnIterator = null;
                                this.currentEntry = null;
                            } else if (this.subColumnIterator != null && this.subColumnIterator.hasNext()) {
                                next = true;
                            }
                        } else {
                            next = true;
                        }
                        if (!next) break block12;
                        this.currentKey = this.convertByteBuffer(this.cfrr.getCurrentKey());
                        this.currentValue.clear();
                        entry = this.currentEntry;
                        if (this.subColumnIterator != null && this.subColumnIterator.hasNext()) break block13;
                    } while (!this.columnIterator.hasNext());
                    this.currentEntry = entry = this.columnIterator.next();
                    this.subColumnIterator = null;
                }
                boolean superColumn = entry.getValue() instanceof SuperColumn;
                this.currentValue.put((Writable)keyColumn, (Writable)this.currentKey);
                this.currentValue.put((Writable)columnColumn, (Writable)this.convertByteBuffer(this.currentEntry.getValue().name()));
                if (superColumn) {
                    if (this.subColumnIterator == null) {
                        this.subColumnIterator = entry.getValue().getSubColumns().iterator();
                    }
                    IColumn subCol = this.subColumnIterator.next();
                    this.currentValue.put((Writable)subColumnColumn, (Writable)this.convertByteBuffer(subCol.name()));
                    this.currentValue.put((Writable)valueColumn, (Writable)this.convertByteBuffer(subCol.value()));
                } else {
                    this.currentValue.put((Writable)valueColumn, (Writable)this.convertByteBuffer(this.currentEntry.getValue().value()));
                }
            } else {
                next = this.cfrr.nextKeyValue();
                this.currentValue.clear();
                if (next) {
                    this.currentKey = this.convertByteBuffer(this.cfrr.getCurrentKey());
                    this.currentValue.put((Writable)keyColumn, (Writable)this.currentKey);
                    this.populateMap(this.cfrr.getCurrentValue(), this.currentValue);
                }
            }
        }
        return next;
    }

    private void populateMap(SortedMap<ByteBuffer, IColumn> cvalue, MapWritable value) {
        for (Map.Entry<ByteBuffer, IColumn> e : cvalue.entrySet()) {
            ByteBuffer k = e.getKey();
            IColumn v = e.getValue();
            if (!v.isLive()) continue;
            BytesWritable newKey = this.convertByteBuffer(k);
            BytesWritable newValue = this.convertByteBuffer(v.value());
            value.put((Writable)newKey, (Writable)newValue);
        }
    }
}

