/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cassandra;

import java.util.Map;
import java.util.Properties;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cassandra.CassandraManager;
import org.apache.hadoop.hive.cassandra.input.HiveCassandraStandardColumnInputFormat;
import org.apache.hadoop.hive.cassandra.output.HiveCassandraOutputFormat;
import org.apache.hadoop.hive.cassandra.serde.AbstractColumnSerDe;
import org.apache.hadoop.hive.cassandra.serde.CassandraColumnSerDe;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.OutputFormat;

public class CassandraStorageHandler
implements HiveStorageHandler,
HiveMetaHook {
    private Configuration configuration;

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        Properties tableProperties = tableDesc.getProperties();
        String tableName = tableProperties.getProperty("name");
        String dbName = tableProperties.getProperty("db");
        String keyspace = tableProperties.getProperty("cassandra.ks.name");
        String columnFamily = tableProperties.getProperty("cassandra.cf.name");
        if (keyspace == null) {
            keyspace = dbName;
        }
        jobProperties.put("cassandra.ks.name", keyspace);
        if (columnFamily == null) {
            columnFamily = tableName;
        }
        jobProperties.put("cassandra.cf.name", columnFamily);
        String columnInfo = tableProperties.getProperty("cassandra.columns.mapping");
        if (columnInfo == null) {
            columnInfo = AbstractColumnSerDe.createColumnMappingString(tableProperties.getProperty("columns"));
        }
        jobProperties.put("cassandra.columns.mapping", columnInfo);
        if (this.configuration.get("cassandra.host") == null) {
            jobProperties.put("cassandra.host", tableProperties.getProperty("cassandra.host", "localhost"));
        } else {
            jobProperties.put("cassandra.host", this.configuration.get("cassandra.host"));
        }
        if (this.configuration.get("cassandra.port") == null) {
            jobProperties.put("cassandra.port", tableProperties.getProperty("cassandra.port", "9160"));
        } else {
            jobProperties.put("cassandra.port", this.configuration.get("cassandra.port"));
        }
        if (this.configuration.get("cassandra.partitioner") == null) {
            jobProperties.put("cassandra.partitioner", tableProperties.getProperty("cassandra.partitioner", "org.apache.cassandra.dht.RandomPartitioner"));
        } else {
            jobProperties.put("cassandra.partitioner", this.configuration.get("cassandra.partitioner"));
        }
        if (this.configuration.get("cassandra.consistency.level") == null) {
            jobProperties.put("cassandra.consistency.level", tableProperties.getProperty("cassandra.consistency.level", "ONE"));
        } else {
            jobProperties.put("cassandra.consistency.level", this.configuration.get("cassandra.consistency.level"));
        }
        if (this.configuration.get("cassandra.range.size") == null) {
            jobProperties.put("cassandra.range.size", tableProperties.getProperty("cassandra.range.size", Integer.toString(1000)));
        } else {
            jobProperties.put("cassandra.range.size", this.configuration.get("cassandra.range.size"));
        }
        if (this.configuration.get("cassandra.slice.predicate.size") == null) {
            jobProperties.put("cassandra.slice.predicate.size", tableProperties.getProperty("cassandra.slice.predicate.size", Integer.toString(1000)));
        } else {
            jobProperties.put("cassandra.slice.predicate.size", this.configuration.get("cassandra.slice.predicate.size"));
        }
        if (this.configuration.get("cassandra.input.split.size") == null) {
            jobProperties.put("cassandra.input.split.size", tableProperties.getProperty("cassandra.input.split.size", Integer.toString(65536)));
        } else {
            jobProperties.put("cassandra.input.split.size", this.configuration.get("cassandra.input.split.size"));
        }
        if (this.configuration.get("cassandra.batchmutate.size") == null) {
            jobProperties.put("cassandra.batchmutate.size", tableProperties.getProperty("cassandra.batchmutate.size", Integer.toString(500)));
        } else {
            jobProperties.put("cassandra.batchmutate.size", this.configuration.get("cassandra.batchmutate.size"));
        }
        if (this.configuration.get("cassandra.slice.predicate.range.start") == null) {
            jobProperties.put("cassandra.slice.predicate.range.start", tableProperties.getProperty("cassandra.slice.predicate.range.start", ""));
        } else {
            jobProperties.put("cassandra.slice.predicate.range.start", this.configuration.get("cassandra.slice.predicate.range.start"));
        }
        if (this.configuration.get("cassandra.slice.predicate.range.finish") == null) {
            jobProperties.put("cassandra.slice.predicate.range.finish", tableProperties.getProperty("cassandra.slice.predicate.range.finish", ""));
        } else {
            jobProperties.put("cassandra.slice.predicate.range.finish", this.configuration.get("cassandra.slice.predicate.range.finish"));
        }
        if (this.configuration.get("cassandra.slice.predicate.range.comparator") == null) {
            jobProperties.put("cassandra.slice.predicate.range.comparator", tableProperties.getProperty("cassandra.slice.predicate.range.comparator", ""));
        } else {
            jobProperties.put("cassandra.slice.predicate.range.comparator", this.configuration.get("cassandra.slice.predicate.range.comparator"));
        }
        if (this.configuration.get("cassandra.slice.predicate.range.reversed") == null) {
            jobProperties.put("cassandra.slice.predicate.range.reversed", tableProperties.getProperty("cassandra.slice.predicate.range.reversed", "false"));
        } else {
            jobProperties.put("cassandra.slice.predicate.range.reversed", this.configuration.get("cassandra.slice.predicate.range.reversed"));
        }
    }

    public Class<? extends InputFormat> getInputFormatClass() {
        return HiveCassandraStandardColumnInputFormat.class;
    }

    public HiveMetaHook getMetaHook() {
        return this;
    }

    public HiveAuthorizationProvider getAuthorizationProvider() throws HiveException {
        return null;
    }

    public void configureInputJobProperties(TableDesc inTableDesc, Map<String, String> inStringStringMap) {
        this.configureTableJobProperties(inTableDesc, inStringStringMap);
    }

    public void configureOutputJobProperties(TableDesc inTableDesc, Map<String, String> inStringStringMap) {
        this.configureTableJobProperties(inTableDesc, inStringStringMap);
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return HiveCassandraOutputFormat.class;
    }

    public Class<? extends SerDe> getSerDeClass() {
        return CassandraColumnSerDe.class;
    }

    public Configuration getConf() {
        return this.configuration;
    }

    public void setConf(Configuration arg0) {
        this.configuration = arg0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCreateTable(Table table) throws MetaException {
        boolean isExternal = MetaStoreUtils.isExternalTable((Table)table);
        if (!isExternal) {
            throw new MetaException("Cassandra tables must be external.");
        }
        if (table.getSd().getLocation() != null) {
            throw new MetaException("LOCATION may not be specified for Cassandra.");
        }
        CassandraManager manager = new CassandraManager(table);
        try {
            manager.openConnection();
            KsDef ks = manager.getKeyspaceDesc();
            manager.createCFIfNotFound(ks);
        }
        catch (NotFoundException e) {
            manager.createKeyspaceWithColumns();
        }
        finally {
            manager.closeConnection();
        }
    }

    public void commitCreateTable(Table table) throws MetaException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitDropTable(Table table, boolean deleteData) throws MetaException {
        boolean isExternal = MetaStoreUtils.isExternalTable((Table)table);
        if (deleteData && !isExternal) {
            CassandraManager manager = new CassandraManager(table);
            try {
                manager.openConnection();
                manager.dropTable();
            }
            finally {
                manager.closeConnection();
            }
        }
    }

    public void preDropTable(Table table) throws MetaException {
    }

    public void rollbackCreateTable(Table table) throws MetaException {
    }

    public void rollbackDropTable(Table table) throws MetaException {
    }
}

