/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cassandra;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.hadoop.hive.cassandra.CassandraClientHolder;
import org.apache.hadoop.hive.cassandra.CassandraException;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class CassandraProxyClient
implements InvocationHandler {
    private static final Logger logger = Logger.getLogger(CassandraProxyClient.class);
    private final String host;
    private final int port;
    private String lastUsedHost;
    private long lastPoolCheck;
    private CassandraClientHolder clientHolder;
    private String ringKs;
    private RingConnOption nextServerGen;
    private final int maxAttempts = 10;

    public CassandraProxyClient(String host, int port, boolean framed, boolean randomizeConnections) throws CassandraException {
        this.host = host;
        this.port = port;
        this.lastUsedHost = host;
        this.lastPoolCheck = 0L;
        this.nextServerGen = randomizeConnections ? new RandomizerOption() : new RoundRobinOption();
        this.initializeConnection();
    }

    public Cassandra.Iface getProxyConnection() {
        return (Cassandra.Iface)Proxy.newProxyInstance(Cassandra.Client.class.getClassLoader(), Cassandra.Client.class.getInterfaces(), (InvocationHandler)this);
    }

    public void close() {
        if (this.clientHolder != null) {
            this.clientHolder.close();
        }
    }

    private CassandraClientHolder createConnection(String host) throws CassandraException {
        TSocket socket = new TSocket(host, this.port);
        TFramedTransport trans = new TFramedTransport((TTransport)socket);
        CassandraClientHolder ch = new CassandraClientHolder((TTransport)trans);
        return ch;
    }

    private void initializeConnection() throws CassandraException {
        this.clientHolder = this.createConnection(this.host);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Connected to cassandra at " + this.host + ":" + this.port));
        }
        assert (this.clientHolder.isOpen());
        try {
            List allKs = this.clientHolder.getClient().describe_keyspaces();
            if (allKs.isEmpty() || allKs.size() == 1 && ((KsDef)allKs.get((int)0)).name.equalsIgnoreCase("system")) {
                allKs.add(this.createTmpKs());
            }
            for (KsDef ks : allKs) {
                if (ks.name.equalsIgnoreCase("system")) continue;
                this.ringKs = ks.name;
                break;
            }
            this.clientHolder.setKeyspace(this.ringKs);
        }
        catch (InvalidRequestException e) {
            throw new CassandraException(e);
        }
        catch (TException e) {
            throw new CassandraException(e);
        }
        catch (SchemaDisagreementException e) {
            throw new CassandraException(e);
        }
        this.checkRing();
    }

    private KsDef createTmpKs() throws InvalidRequestException, TException, SchemaDisagreementException {
        HashMap<String, String> stratOpts = new HashMap<String, String>();
        stratOpts.put("replication_factor", "1");
        KsDef tmpKs = new KsDef("proxy_client_ks", "org.apache.cassandra.locator.SimpleStrategy", Arrays.asList(new CfDef[0])).setStrategy_options(stratOpts);
        this.clientHolder.getClient().system_add_keyspace(tmpKs);
        return tmpKs;
    }

    private void checkRing() throws CassandraException {
        assert (this.clientHolder != null);
        long now = System.currentTimeMillis();
        if (now - this.lastPoolCheck > 60000L) {
            List ring;
            try {
                ring = this.clientHolder.getClient().describe_ring(this.ringKs);
            }
            catch (InvalidRequestException e) {
                throw new CassandraException(e);
            }
            catch (TException e) {
                throw new CassandraException(e);
            }
            this.lastPoolCheck = now;
            this.nextServerGen.resetRing(ring);
        }
    }

    private void attemptReconnect() throws CassandraException {
        String endpoint = this.nextServerGen.getNextServer(this.lastUsedHost);
        if (endpoint != null) {
            this.clientHolder = this.createConnection(endpoint);
            this.lastUsedHost = endpoint;
            this.checkRing();
            logger.info((Object)("Connected to cassandra at " + endpoint + ":" + this.port));
        } else {
            this.clientHolder = this.createConnection(this.lastUsedHost);
        }
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result = null;
        int tries = 0;
        while (result == null && tries++ < 10) {
            try {
                if (this.clientHolder == null) {
                    this.attemptReconnect();
                }
                if (this.clientHolder == null || !this.clientHolder.isOpen()) continue;
                result = m.invoke((Object)this.clientHolder.getClient(), args);
                if (m.getName().equalsIgnoreCase("set_keyspace") && args != null && args.length == 1) {
                    this.ringKs = (String)args[0];
                }
                return result;
            }
            catch (CassandraException e) {
                if (tries < 10) continue;
                throw e.getCause();
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof UnavailableException || e.getTargetException() instanceof TimedOutException || e.getTargetException() instanceof TTransportException) {
                    if (tries < 10) continue;
                    throw e.getCause();
                }
                throw e.getCause();
            }
        }
        throw new CassandraException("Not able to connect to any server in the ring " + this.lastUsedHost);
    }

    public class RoundRobinOption
    extends RingConnOption {
        private int lastUsedIndex;

        public RoundRobinOption() {
        }

        public RoundRobinOption(List<TokenRange> rings) {
            super(rings);
            this.lastUsedIndex = 0;
        }

        @Override
        protected String getServerFromRing(String thisHost) {
            String endpoint = thisHost;
            while (!endpoint.equals(thisHost)) {
                ++this.lastUsedIndex;
                if (this.lastUsedIndex == this.servers.size()) {
                    this.lastUsedIndex = 0;
                }
                endpoint = (String)this.servers.get(this.lastUsedIndex);
            }
            return endpoint;
        }
    }

    public class RandomizerOption
    extends RingConnOption {
        private final Random generator;

        public RandomizerOption() {
            this.generator = new Random();
        }

        public RandomizerOption(List<TokenRange> rings) {
            super(rings);
            this.generator = new Random();
        }

        @Override
        protected String getServerFromRing(String thisHost) {
            String endpoint = thisHost;
            while (!endpoint.equals(thisHost)) {
                int index = this.generator.nextInt(this.servers.size());
                endpoint = (String)this.servers.get(index);
            }
            return endpoint;
        }
    }

    public abstract class RingConnOption {
        protected List<String> servers;

        protected RingConnOption() {
        }

        protected RingConnOption(List<TokenRange> servers) {
            this.servers = this.getAllServers(servers);
        }

        public String getNextServer(String host) throws CassandraException {
            if (!this.checkServerHealth()) {
                throw new CassandraException("No server is available from the ring.");
            }
            if (this.servers.size() == 1) {
                if (this.servers.get(0).equals(host)) {
                    return null;
                }
                return this.servers.get(0);
            }
            return this.getServerFromRing(host);
        }

        protected abstract String getServerFromRing(String var1);

        public void resetRing(List<TokenRange> servers) {
            this.servers = this.getAllServers(servers);
        }

        private List<String> getAllServers(List<TokenRange> input) {
            HashMap<String, Integer> map = new HashMap<String, Integer>(input.size());
            for (TokenRange thisRange : input) {
                List servers = thisRange.rpc_endpoints;
                for (String newServer : servers) {
                    map.put(newServer, new Integer(1));
                }
            }
            return new ArrayList<String>(map.keySet());
        }

        private boolean checkServerHealth() {
            if (this.servers == null || this.servers.size() == 0) {
                logger.warn((Object)"No cassandra ring information found, no node is available to connect to");
                return false;
            }
            return true;
        }
    }
}

