/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cassandra;

import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.cassandra.CassandraException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraClientHolder {
    private static final Logger log = LoggerFactory.getLogger(CassandraClientHolder.class);
    private Cassandra.Client client;
    private final TTransport transport;
    private String keyspace;

    public CassandraClientHolder(TTransport transport) throws CassandraException {
        this(transport, null);
    }

    public CassandraClientHolder(TTransport transport, String keyspace) throws CassandraException {
        this.transport = transport;
        this.keyspace = keyspace;
        this.initClient();
    }

    public boolean isOpen() {
        return this.client != null && this.transport != null && this.transport.isOpen();
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    private void initClient() throws CassandraException {
        try {
            this.transport.open();
        }
        catch (TTransportException e) {
            throw new CassandraException("unable to connect to server", e);
        }
        this.client = new Cassandra.Client((TProtocol)new TBinaryProtocol(this.transport));
        this.setKeyspace(this.keyspace);
    }

    public void setKeyspace(String ks) throws CassandraException {
        if (ks == null) {
            return;
        }
        if (this.keyspace == null || !StringUtils.equals((String)this.keyspace, (String)ks)) {
            try {
                this.keyspace = ks;
                this.client.set_keyspace(this.keyspace);
            }
            catch (InvalidRequestException e) {
                throw new CassandraException(e);
            }
            catch (TException e) {
                throw new CassandraException(e);
            }
        }
    }

    public Cassandra.Client getClient() {
        return this.client;
    }

    public void close() {
        if (this.transport == null || !this.transport.isOpen()) {
            return;
        }
        try {
            this.transport.flush();
        }
        catch (Exception e) {
            log.error("Could not flush transport for client holder: " + this.toString(), (Throwable)e);
        }
        finally {
            try {
                if (this.transport.isOpen()) {
                    this.transport.close();
                }
            }
            catch (Exception e) {
                log.error("Error on transport close for client: " + this.toString(), (Throwable)e);
            }
        }
    }
}

