/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.hadoop.hive.jdbc.storage.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.wso2.carbon.hadoop.hive.jdbc.storage.datasource.CarbonDataSourceFetcher;
import org.wso2.carbon.hadoop.hive.jdbc.storage.utils.Commons;

public class ConfigurationUtils {
    public static final String HIVE_JDBC_UPDATE_ON_DUPLICATE = "hive.jdbc.update.on.duplicate";
    public static final String HIVE_JDBC_PRIMARY_KEY_FIELDS = "hive.jdbc.primary.key.fields";
    public static final String HIVE_JDBC_INPUT_COLUMNS_MAPPING = "hive.jdbc.input.columns.mapping";
    public static final String HIVE_JDBC_OUTPUT_COLUMNS_MAPPING = "hive.jdbc.output.columns.mapping";
    public static final String HIVE_JDBC_OUTPUT_SQL_QUERY_BEFORE_DATA_INSERT = "hive.jdbc.sql.query.before.data.insert";
    public static final String HIVE_JDBC_TABLE_CREATE_QUERY = "hive.jdbc.table.create.query";
    public static final String HIVE_JDBC_OUTPUT_UPSERT_QUERY = "hive.jdbc.output.upsert.query";
    public static final String HIVE_JDBC_UPSERT_QUERY_VALUES_ORDER = "hive.jdbc.upsert.query.values.order";
    public static final String HIVE_PROP_CARBON_DS_NAME = "wso2.carbon.datasource.name";
    public static final String[] ALL_PROPERTIES = new String[]{"mapred.jdbc.driver.class", "mapred.jdbc.username", "mapred.jdbc.password", "mapred.jdbc.url", "mapred.jdbc.output.table.name", "mapred.jdbc.output.field.names", "mapred.jdbc.input.table.name", "name", "hive.jdbc.update.on.duplicate", "hive.jdbc.primary.key.fields", "hive.jdbc.input.columns.mapping", "hive.jdbc.output.columns.mapping", "hive.jdbc.table.create.query", "hive.jdbc.output.upsert.query", "hive.jdbc.upsert.query.values.order", "wso2.carbon.datasource.name", "hive.jdbc.sql.query.before.data.insert"};

    public static void copyJDBCProperties(Properties from, Map<String, String> to) {
        for (String key : ALL_PROPERTIES) {
            String value = from.getProperty(key);
            if (value == null) continue;
            to.put(key, value);
            if (!key.equals(HIVE_PROP_CARBON_DS_NAME)) continue;
            ConfigurationUtils.addingProperties(value, to);
        }
    }

    private static void addingProperties(String dataSourceName, Map<String, String> to) {
        CarbonDataSourceFetcher carbonDataSourceFetcher = new CarbonDataSourceFetcher();
        Map<String, String> dataSource = carbonDataSourceFetcher.getCarbonDataSource(dataSourceName);
        to.putAll(dataSource);
    }

    public static final String getOutputTableName(Configuration configuration) {
        String tableName = configuration.get("mapred.jdbc.output.table.name");
        if (tableName == null) {
            String createTableQuery = configuration.get(HIVE_JDBC_TABLE_CREATE_QUERY);
            if (createTableQuery != null) {
                tableName = Commons.extractingTableNameFromQuery(createTableQuery);
            } else {
                tableName = configuration.get("name");
                if (tableName.contains("default.")) {
                    tableName = tableName.replace("default.", "");
                }
            }
        }
        return tableName;
    }

    public static final String getInputTableName(Configuration configuration) {
        String inputTableName = configuration.get("mapred.jdbc.input.table.name");
        if (inputTableName == null && (inputTableName = configuration.get("name")).contains("default.")) {
            inputTableName = inputTableName.replace("default.", "");
        }
        return inputTableName.trim();
    }

    public static final String getConnectionUrl(Configuration conf) {
        return conf.get("mapred.jdbc.url");
    }

    public static final String getDriverClass(Configuration conf) {
        return conf.get("mapred.jdbc.driver.class");
    }

    public static final String getDatabaseUserName(Configuration conf) {
        return conf.get("mapred.jdbc.username");
    }

    public static final String getDatabasePassword(Configuration conf) {
        return conf.get("mapred.jdbc.password");
    }

    public static final Map<String, String> mapTableFieldNamesAgainstHiveFieldNames(Configuration conf) {
        HashMap<String, String> mapFields = new HashMap<String, String>();
        Object[] fieldNames = null;
        String[] dbTableFieldName = null;
        String inputFieldNames = conf.get(HIVE_JDBC_INPUT_COLUMNS_MAPPING);
        fieldNames = conf.get("columns").split(",");
        fieldNames = (String[])ArrayUtils.removeElement((Object[])fieldNames, (Object)"BLOCK__OFFSET__INSIDE__FILE");
        fieldNames = (String[])ArrayUtils.removeElement((Object[])fieldNames, (Object)"INPUT__FILE__NAME");
        fieldNames = ConfigurationUtils.trim((String[])fieldNames);
        if (inputFieldNames != null) {
            dbTableFieldName = inputFieldNames.split(",");
            if ((dbTableFieldName = ConfigurationUtils.trim(dbTableFieldName)).length != fieldNames.length) {
                throw new IllegalArgumentException("hive.jdbc.input.columns.mapping size " + dbTableFieldName.length + " doesn't match with no of hive meta table columns, which is " + fieldNames.length);
            }
            for (int i = 0; i < dbTableFieldName.length; ++i) {
                mapFields.put(dbTableFieldName[i], (String)fieldNames[i]);
            }
        } else {
            for (int i = 0; i < fieldNames.length; ++i) {
                mapFields.put((String)fieldNames[i], (String)fieldNames[i]);
            }
        }
        return mapFields;
    }

    protected static String[] trim(String[] input) {
        String[] trimmed = new String[input.length];
        for (int i = 0; i < input.length; ++i) {
            trimmed[i] = input[i].trim();
        }
        return trimmed;
    }

    public static final String[] getOutputFieldNames(Configuration conf) {
        String[] fieldNames = null;
        String outputFieldNames = conf.get("mapred.jdbc.output.field.names");
        if (outputFieldNames != null) {
            fieldNames = outputFieldNames.split(",");
        }
        return fieldNames;
    }

    public static final boolean isUpdateOnDuplicate(Configuration conf) {
        return Boolean.parseBoolean(conf.get(HIVE_JDBC_UPDATE_ON_DUPLICATE));
    }

    public static final String[] getPrimaryKeyFields(Configuration conf) {
        String primaryKeyFields = conf.get(HIVE_JDBC_PRIMARY_KEY_FIELDS);
        if (primaryKeyFields != null) {
            return ConfigurationUtils.convertingToLowerCase(primaryKeyFields.split(","));
        }
        return null;
    }

    private static String[] convertingToLowerCase(String[] primaryKeyFields) {
        if (primaryKeyFields != null) {
            String[] fields = new String[primaryKeyFields.length];
            for (int i = 0; i < primaryKeyFields.length; ++i) {
                fields[i] = primaryKeyFields[i].toLowerCase();
            }
            return fields;
        }
        return null;
    }

    public static final String[] getColumnMappingFields(Configuration conf) {
        String mappingFields = conf.get(HIVE_JDBC_OUTPUT_COLUMNS_MAPPING);
        if (mappingFields != null) {
            return mappingFields.split(",");
        }
        return null;
    }

    public static String getDbSpecificUpdateQuery(JobConf conf) {
        return conf.get(HIVE_JDBC_OUTPUT_UPSERT_QUERY);
    }

    public static String[] getUpsertQueryValuesOrder(JobConf conf) {
        String valuesOrder = conf.get(HIVE_JDBC_UPSERT_QUERY_VALUES_ORDER);
        String[] order = null;
        if (valuesOrder != null) {
            valuesOrder = valuesOrder.trim();
            order = ConfigurationUtils.trim(valuesOrder.split(","));
        }
        return order;
    }

    public static String getWso2CarbonDataSourceName(JobConf conf) {
        return conf.get(HIVE_PROP_CARBON_DS_NAME);
    }
}

