/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.hadoop.hive.jdbc.storage.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.hadoop.hive.jdbc.storage.db.DBManager;
import org.wso2.carbon.hadoop.hive.jdbc.storage.db.DatabaseProperties;
import org.wso2.carbon.hadoop.hive.jdbc.storage.db.DatabaseType;
import org.wso2.carbon.hadoop.hive.jdbc.storage.db.QueryConstructor;
import org.wso2.carbon.hadoop.hive.jdbc.storage.exception.UnsupportedDatabaseException;
import org.wso2.carbon.hadoop.hive.jdbc.storage.input.JDBCSplit;

public class DBRecordReader
implements RecordReader<LongWritable, MapWritable> {
    private static final Logger log = LoggerFactory.getLogger(DBRecordReader.class);
    private Connection connection;
    private Statement statement;
    private ResultSet results;
    private JDBCSplit split;
    private long pos = 0L;
    private DatabaseProperties databaseProperties;

    public DBRecordReader(JDBCSplit split, DatabaseProperties dbProperties, DBManager dbManager) {
        DatabaseType databaseType = null;
        String sqlQuery = null;
        try {
            this.split = split;
            this.databaseProperties = dbProperties;
            this.connection = dbManager.getConnection();
            this.connection.setAutoCommit(false);
            this.statement = this.connection.createStatement(1003, 1007);
            if (dbProperties.getConnectionUrl() != null) {
                String databaseName = dbProperties.getConnectionUrl().split(":")[1];
                databaseType = dbManager.getDatabaseType(databaseName);
            } else {
                databaseType = dbManager.getDatabaseName(this.connection);
            }
            sqlQuery = new QueryConstructor().constructSelectQueryForReading(dbProperties, split, databaseType);
            this.results = this.statement.executeQuery(sqlQuery);
        }
        catch (ClassNotFoundException e) {
            log.error("Failed to get connection", (Throwable)e);
        }
        catch (SQLException e) {
            log.error("Failed to fetch data from database using query: " + sqlQuery, (Throwable)e);
        }
        catch (UnsupportedDatabaseException e) {
            log.error("This database doesn't support by hive-jdbc-handler", (Throwable)e);
        }
    }

    public boolean next(LongWritable key, MapWritable value) throws IOException {
        try {
            if (!this.results.next()) {
                return false;
            }
            key.set(this.pos + this.split.getStart());
            ResultSetMetaData resultsMetaData = this.results.getMetaData();
            int columnCount = resultsMetaData.getColumnCount();
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<Integer> types = new ArrayList<Integer>();
            for (int i = 1; i <= columnCount; ++i) {
                String name = resultsMetaData.getColumnName(i).toLowerCase();
                name = this.databaseProperties.getInputColumnMappingFields().get(name);
                int type = resultsMetaData.getColumnType(i);
                names.add(name.toLowerCase());
                types.add(type);
            }
            for (int j = 0; j < types.size(); ++j) {
                value.put((Writable)new Text((String)names.get(j)), this.getActualObjectTypeForValue(this.results, types, j));
            }
            ++this.pos;
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
        return true;
    }

    private Writable getActualObjectTypeForValue(ResultSet results, List<Integer> types, int i) {
        int sqlType = types.get(i);
        int columnNo = i + 1;
        try {
            switch (sqlType) {
                case -16: 
                case -15: 
                case -9: 
                case 1: 
                case 12: {
                    String result = results.getString(columnNo);
                    if (result != null) {
                        return new Text(results.getString(columnNo));
                    }
                    return new Text("");
                }
                case 4: 
                case 5: {
                    return new IntWritable(results.getInt(columnNo));
                }
                case -7: {
                    return new BooleanWritable(results.getBoolean(columnNo));
                }
                case 2: {
                    return new DoubleWritable(results.getBigDecimal(columnNo).doubleValue());
                }
                case -5: {
                    return new LongWritable(results.getLong(columnNo));
                }
                case 7: {
                    return new FloatWritable(results.getFloat(columnNo));
                }
                case 8: {
                    return new DoubleWritable(results.getDouble(columnNo));
                }
                case -6: {
                    return new ByteWritable(results.getByte(columnNo));
                }
                case 0: {
                    return null;
                }
            }
            return new Text(results.getString(columnNo));
        }
        catch (SQLException e) {
            log.error("Failed to get value for column no: " + columnNo, (Throwable)e);
            return null;
        }
    }

    public LongWritable createKey() {
        return new LongWritable();
    }

    public MapWritable createValue() {
        return new MapWritable();
    }

    public long getPos() throws IOException {
        return this.pos;
    }

    public void close() throws IOException {
        try {
            this.connection.commit();
            this.results.close();
            this.statement.close();
        }
        catch (SQLException e) {
            log.error("Failed to close", (Throwable)e);
        }
    }

    public float getProgress() throws IOException {
        return this.split.getLength() > 0L ? (float)this.pos / (float)this.split.getLength() : 1.0f;
    }
}

